import React from 'react';
import { Modal, Form, Select, Input, Table } from 'antd';

const FormItem = Form.Item;
const { Option } = Select;

const LogisticsForm = props => {
  const { modalVisible, onCancel, value } = props;

  const columns = [
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
    },
    {
      title: '商品属性',
      dataIndex: 'skuAttr',
      key: 'skuAttr',
    },
    {
      title: '商品件数（件）',
      dataIndex: 'count',
      key: 'count',
    },
    {
      title: '物流公司',
      dataIndex: 'expressCompanyName',
      key: 'expressCompanyName',
    },
    {
      title: '物流单号',
      dataIndex: 'deliveryNo',
      key: 'deliveryNo',
    }
  ];
  const style = {
    width: '700px'
  };
  return (
    <Modal
      title="订单详情"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      bodyStyle={style}
      width={700}
    >
      <Table columns={columns} dataSource={value} />
    </Modal>
  );
};

export default Form.create()(LogisticsForm);
