import React from 'react';
import { Divider } from 'antd';

export const getColumns = props => {
  const {
    toUserInfo,
    openRolePermissionsModal,
    openUpdateStatusModal,
    openResetPasswordModal,
    canEditable,
  } = props;
  return [
    {
      title: '用户名',
      dataIndex: 'account',
    },
    {
      title: '姓名',
      dataIndex: 'name',
    },
    {
      title: '创建时间',
      dataIndex: 'createTime',
      hideInSearch: true,
    },
    {
      title: '最后一次登录时间',
      dataIndex: 'lastLogin',
      hideInSearch: true,
    },
    {
      title: '角色',
      dataIndex: 'creator',
      render: (value, record) => {
        const { roles } = record;
        const roleElement = roles.map((role, index) => (
          <>
            <a onClick={() => openRolePermissionsModal(role)}>{role.name}</a>
            {roles.length - 1 !== index ? '，' : ''}
          </>
        ));
        return roleElement;
      },
    },
    {
      title: '状态',
      dataIndex: 'status',
      width: 150,
      initialValue: '3',
      hideInFilter: true,
      valueEnum: {
        all: { text: '全部', status: '' },
        close: { text: '使用中', status: 2 },
        running: { text: '已禁用', status: 3 },
      },
      render: value => {
        const textMapping = {
          2: '已使用',
          3: '已禁用',
        };
        return textMapping[value.value] || '-';
      },
    },
    {
      title: '操作',
      key: 'action',
      width: 220,
      hideInSearch: true,
      render: (value, record) => {
        if (!canEditable) {
          return <>-</>;
        }
        return (
          <>
            <a
              onClick={() => {
                toUserInfo(record);
              }}
            >
              编辑
            </a>
            <Divider type="vertical" />
            <a
              onClick={() => {
                openUpdateStatusModal(record);
              }}
            >
              修改状态
            </a>
            <Divider type="vertical" />
            <a
              onClick={() => {
                openResetPasswordModal(record);
              }}
            >
              重置密码
            </a>
          </>
        );
      },
    },
  ];
};
