import React from 'react';
import { Form, InputNumber } from 'antd';
import { validateRequired, isCheckPriceTwoDecimal } from '@/utils/validator';

const MealLimit = props => (
  // console.log('props :>> ', props);
  <Form.Item
    label={`${props.label}限额`}
    name={props.name}
    initialValue={props.value}
    labelCol={{ span: 10 }}
    wrapperCol={{ span: 14 }}
    rules={[
      { validator: validateRequired, message: `请输入${props.label}限额` },
      { validator: isCheckPriceTwoDecimal, message: '请输入正确的价格' },
    ]}
  >
    <InputNumber addonAfter="元" max={999.99} />
  </Form.Item>
);
export default MealLimit;
