import { Button, Form, Input, Select, notification, Upload, Cascader, InputNumber } from 'antd';
import React, { Component } from 'react';
import { connect } from 'dva';
import styles from '../style.less';
import { stateList } from '../staticdata';
import { uploadFile } from '../service';

const FormItem = Form.Item;
const { Option } = Select;
@connect(({ goodsManage }) => ({
  goodsManage,
}))
class goodsManage extends Component {
  componentDidMount() {
    this.props.onRef(this);
    this.handleSearch();
  }

  getFieldsValue() {
    const { form } = this.props;
    return form.getFieldsValue();
  }

  handleSearch = () => {
    this.props.handleSearch(1);
  };

  onReset = () => {
    this.props.form.resetFields();
    this.props.onReset();
  };

  addSpu = () => {
    this.props.addSpu();
  };

  render() {
    const {
      form: { getFieldDecorator, getFieldValue },
      treeData,
    } = this.props;
    const selectW = { width: 250 };
    const iptNumWidth = { width: 118 };
    const that = this;

    const uploadProps = {
      name: 'file',
      async customRequest(info) {
        const result = await uploadFile(info.file);
        if (result && result.businessCode === '0000') {
          that.handleSearch();
          notification.success({
            message: '操作成功',
          });
        } else {
          notification.warning({
            message: result.msg,
            description: (
              <div>
                {result.data?.length &&
                  result.data.map(item => <p>{item.skuNo + item.errSkuMessage}</p>)}
              </div>
            ),
            duration: 6,
          });
        }
      },
      accept: '.xlsx',
      showUploadList: false,
    };

    const filterOption = (input, op) => op.props.children.includes(input);
    return (
      <Form name="horizontal_login" layout="inline" className={styles.searchForm}>
        <FormItem label="SKU编码">
          {getFieldDecorator('skuId', {})(
            <Input placeholder="请输入SKU编码" allowClear style={selectW} />,
          )}
        </FormItem>
        <FormItem label="商品名称">
          {getFieldDecorator('skuName', {})(
            <Input placeholder="请输入商品名称" allowClear style={selectW} />,
          )}
        </FormItem>
        <FormItem label="类目">
          {getFieldDecorator('productCategoryId', {})(
            <Cascader
              placeholder="请选择类目"
              style={selectW}
              showSearch
              changeOnSelect
              fieldNames={{ label: 'name', value: 'id', children: 'children' }}
              options={treeData}
            />,
          )}
        </FormItem>
        <FormItem label="审核状态">
          {getFieldDecorator('state', {})(
            <Select
              style={selectW}
              placeholder="请选择审核状态"
              allowClear
              filterOption={filterOption}
            >
              {stateList?.map(item => (
                <Option key={item.value} value={item.value}>
                  {item.label}
                </Option>
              ))}
            </Select>,
          )}
        </FormItem>
        <FormItem label="供货价区间">
          <FormItem className={styles.iptNumRight}>
            {getFieldDecorator('supplyPriceMin', {})(
              <InputNumber placeholder="请输入" style={iptNumWidth} />,
            )}
          </FormItem>
          <span>--</span>
          <FormItem className={styles.iptNumRight}>
            {getFieldDecorator('supplyPriceMax', {})(
              <InputNumber
                style={iptNumWidth}
                placeholder="请输入"
                min={getFieldValue('supplyPriceMin')}
              />,
            )}
          </FormItem>
        </FormItem>
        <FormItem label="第三方SKU编码">
          {getFieldDecorator('thirdSkuNo', {})(
            <Input placeholder="请输入第三方SKU编码" allowClear style={selectW} />,
          )}
        </FormItem>
        <FormItem className={styles.queryBtn}>
          <Button onClick={() => this.handleSearch()} type="primary" className={styles.button}>
            查询
          </Button>
          <Button onClick={() => this.onReset()} type="primary" className={styles.button}>
            重置
          </Button>
        </FormItem>
        <FormItem style={{ float: 'right' }}>
          <Button type="primary" className={styles.button} onClick={this.addSpu}>
            新增商品
          </Button>
          <Button
            className={styles.button}
            type="primary"
            icon="download"
            ghost
            onClick={() => {
              window.location.href = 'https://kdspstatic.q-gp.com/批量修改库存模板.xlsx';
            }}
          >
            模版
          </Button>
          <Upload {...uploadProps}>
            <Button type="primary" className={styles.button}>
              批量库存修改
            </Button>
          </Upload>
        </FormItem>
      </Form>
    );
  }
}

export default Form.create()(goodsManage);
