import React from 'react';
import { Divider, Popconfirm } from 'antd';

export const getColumns = props => {
  const { onDeleteRole, toRoleInfo, canEditable } = props;
  return [
    {
      title: '角色ID',
      dataIndex: 'id',
      hideInTable: true,
    },
    {
      title: '角色名称',
      dataIndex: 'name',
    },
    {
      title: '角色描述',
      dataIndex: 'description',
      hideInSearch: true,
    },
    {
      title: '状态',
      dataIndex: 'status',
      hideInSearch: true,
      render: value => value.name,
    },
    {
      title: '关联账号',
      dataIndex: 'userCount',
      hideInSearch: true,
    },
    {
      title: '创建人',
      dataIndex: 'creator',
      hideInSearch: true,
    },
    {
      title: '创建日期',
      hideInSearch: true,
      dataIndex: 'createTime',
    },
    {
      title: '操作',
      key: 'action',
      hideInSearch: true,
      render: (value, record) => {
        if (!canEditable) {
          return '-';
        }
        return (
          <>
            <a onClick={() => toRoleInfo(record)}>编辑</a>
            {record.userCount === 0 ? (
              <>
                <Divider type="vertical" />
                <Popconfirm
                  placement="top"
                  title="确定删除该角色吗？"
                  onConfirm={() => onDeleteRole(record)}
                  okText="确定"
                  cancelText="取消"
                >
                  <a>删除</a>
                </Popconfirm>
              </>
            ) : (
              ''
            )}
          </>
        );
      },
    },
  ];
};
