import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import config from '../../../config/env.config';

// 查询
export async function query(params) {
  const tempParams = {
    ...params,
    pageNo: params.current,
  };
  delete tempParams.current;

  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/kdsp/supplier/after-sales-addrs-page', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(tempParams, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}
export async function supplier() {
  const { data } = await request.get('/api/kdsp/supplier/supplier-list-query', {
    prefix: config.kdspApi,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

export async function del(id) {
  const data = await request.post('/api/kdsp/supplier/after-sales-addrs-delete', {
    prefix: config.kdspApi,
    data: stringify({ id }),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

export async function update(params) {
  const { businessCode } = await request.post(
    '/api/kdsp/supplier/after-sales-addrs-save-or-update',
    {
      prefix: config.kdspApi,
      data: stringify(params),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    },
  );
  return businessCode;
}
export async function addrQuery(params) {
  const { data } = await request.get('/api/kdsp/area/addr/query', {
    prefix: config.kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}
