export const formItemLayout = {
  labelCol: {
    sm: { span: 3 },
  },
  wrapperCol: {
    sm: { span: 16 },
  },
};

export const TaskList = [
  {
    name: '实体商品',
    type: 1,
    desc: '物流发货',
    hide: true,
    imgConfig: {
      commonImageList: {
        title: '公共滑动图',
        rule: false,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
      imageList: {
        rule: false,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
      detailImageList: {
        title: '详情图',
        rule: true,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
    },
  },
  {
    name: '虚拟商品',
    type: 2,
    desc: '无需物流',
    hide: true,
    imgConfig: {
      commonImageList: {
        title: '公共滑动图',
        rule: false,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
      imageList: {
        rule: false,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
      detailImageList: {
        title: '详情图',
        rule: true,
        limit: null,
        renderExtra: () => '（图片最大上传2M）',
      },
    },
  },
  // {
  //   name: '电子卡卷',
  //   type: 3,
  //   desc: '无需物流',
  //   hide: true,
  //   imgConfig: {
  //     commonImageList: {
  //       title: '封面图片',
  //       rule: true,
  //       limit: 11,
  //       renderExtra(leng) {
  //         return `建议尺寸: ##宽##高 (${leng} / 1) `;
  //       },
  //     },
  //     imageList: {
  //       rule: true,
  //       limit: 1,
  //     },
  //     detailImageList: {
  //       title: '商品图片',
  //       rule: true,
  //       limit: null,
  //       renderExtra() {
  //         return '请上传商品图！';
  //       },
  //     },
  //   },
  // },
  {
    name: '电子卡卷',
    type: 4,
    desc: '无需物流',
    imgConfig: {
      commonImageList: {
        title: '封面图片',
        rule: true,
        limit: 1,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高 (${leng} / 1) 封面图第一张 `;
        },
      },
      cardImageList: {
        title: '商品图片',
        rule: true,
        limit: 11,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高,sku商品轮播图(${leng} / 11)`;
        },
      },
      detailImageList: {
        title: '商品详情图',
        // rule: true,
        limit: 30,
        renderExtra() {
          return '最多上传30张';
        },
      },
    },
  },
];

export const WeeksList = [
  {
    name: '法定节假日',
    value: 8,
  },
  {
    name: '周一',
    value: 1,
  },
  {
    name: '周二',
    value: 2,
  },
  {
    name: '周三',
    value: 3,
  },
  {
    name: '周四',
    value: 4,
  },
  {
    name: '周五',
    value: 5,
  },
  {
    name: '周六',
    value: 6,
  },
  {
    name: '周日',
    value: 7,
  },
];

export const StaticColumns = customer => [
  {
    title: '供货价',
    dataIndex: 'supplyPrice',
    editable: true,
    batchRole: [1, 2, 3, 4],
    roleProps: {
      precision: 2,
      min: 0,
    },
    roleRules: { required: true },
    disabeldRender: () => customer.isJDGoods,
  },
  {
    title: '佣金费率',
    dataIndex: 'commissionRate',
    editable: true,
    role: [4],
    roleRules: { required: false },
    roleProps: {
      min: 0,
      // max: 100,
    },
  },
  {
    title: '市场价',
    dataIndex: 'marketPrice',
    editable: true,
    batchRole: [1, 2, 3, 4],
    roleProps: {
      precision: 2,
      min: 0,
    },
    roleRules: { required: true },
    // disabeldRender: () => customer.isService,
  },
  {
    title: '销售价',
    dataIndex: 'salePrice',
    editable: true,
    batchRole: [4],
    role: [4],
    roleRules: { required: true },
    roleProps: {
      precision: 2,
      min: 0,
    },
  },
  {
    title: '重量(kg)',
    dataIndex: 'weight',
    editable: true,
    batchRole: [1],
    batchProps: {
      min: 0,
      precision: 3,
      max: 999999.999,
    },
    role: [1],
    roleRules: { required: true },
    roleProps: {
      min: 0,
      precision: 3,
      max: 999999.999,
    },
    // disabeldRender: () => customer.isService,
  },
  {
    title: '库存',
    dataIndex: 'productStock',
    editable: true,
    role: [1, 2, 4],
    batchRole: [1, 2, 4],
    batchProps: {
      precision: 0,
      step: 1,
      min: 0,
    },
    roleProps: {
      min: 0,
    },
    roleRules: { required: true },
    disabeldRender: () => customer.isService,
  },
  {
    title: '库存预警',
    dataIndex: 'productStockWarning',
    editable: true,
    batchRole: [1],
    role: [1, 4],
    roleRules: { required: true },
    roleProps: {
      min: 0,
      precision: 0,
      maxLength: 5,
    },
    // disabeldRender: () => customer.isService,
  },
  {
    title: '商品自编码',
    dataIndex: 'thirdSkuNo',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: true },
    disabeldRender: () => customer.isService,
  },
  {
    title: '京东链接',
    dataIndex: 'skuLink',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: false },
    disabeldRender: () => customer.isService,
  },
  {
    title: 'sku名称',
    dataIndex: 'name',
    editable: true,
    role: customer.isEdit && customer.isJDGoods ? [1, 2] : [],
    inputType: 'btnText',
    roleRules: { required: false },
  },
  {
    title: '操作',
    editable: true,
    dataIndex: 'option',
    role: [1, 2],
    inputType: 'option',
    roleProps: {
      isJDGoods: customer.isJDGoods,
      min: 0,
    },
    roleRules: { required: false },
  },
];
