/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
import React, { useState, useEffect } from 'react';
import { Modal, Timeline, Button } from 'antd';
import styles from '../styles.less';

const LogisticsCom = props => {
  const { visible, onCancel, data } = props;
  return (
    <Modal
      destroyOnClose
      title="查看记录"
      visible={visible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      footer={false}
    >
      {data?.length ? (
        <Timeline>
          {data?.map((item, index) => (
            // eslint-disable-next-line react/no-array-index-key
            <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index}>
              <p>{item.optDesc}</p>
              <p>{item.optTime}</p>
            </Timeline.Item>
          ))}
        </Timeline>
      ) : (
        '暂无查看记录'
      )}
      <Button type="primary" onClick={props.onCancel} className={styles.logBtn}>
        关闭
      </Button>
    </Modal>
  );
};

export default LogisticsCom;
