import React, { useState, forwardRef, useImperativeHandle } from 'react';
import { Form } from '@ant-design/compatible';
import { Modal, Button } from 'antd';

// 0: 待财务审核
// 1: 审核通过
// 2: 审核拒绝,

const ExamineFormModal = forwardRef((props, ref) => {
  const { form, claimVisible, closeClaimDescription, refresh } = props;
  const [detailData, setDetailData] = useState({});
  useImperativeHandle(ref, () => ({
    setDetailData,
    ...form,
  }));

  const onCancelEvent = () => {
    closeClaimDescription();
  };

  const footerButton = [
    <Button type="primary" key="cancel" onClick={onCancelEvent}>
      关闭
    </Button>,
  ];
  return (
    <Modal
      title="赔款说明"
      centered
      visible={claimVisible}
      footer={detailData.audit ? footerButton : null}
      bodyStyle={{ padding: '12px 0' }}
      onCancel={onCancelEvent}
    ></Modal>
  );
});

export default Form.create()(ExamineFormModal);
