import React, { useState, useEffect } from 'react';
import { Row, Col } from 'antd';
import { Link } from 'umi';
// import { PageHeaderWrapper } from '@ant-design/pro-layout';
// eslint-disable-next-line import/no-extraneous-dependencies
import { FileTextOutlined } from '@ant-design/icons';
import style from './styles.less';
import { getPendingNum } from './service';

const Admin = () => {
  const [pendingNum, setpendingNum] = useState({});

  useEffect(() => {
    const qurey = async () => {
      const { data } = await getPendingNum();
      setpendingNum(data);
    };
    qurey();
  }, []);

  return (
    <div>
      <h2>欢迎使用商户管理后台系统</h2>
      <div>
        <div>
          <span className={style.orderleft}></span>
          <span className={style.orderRight}>待办事项</span>
        </div>
        <div style={{ marginTop: '20px' }}>
          <Row className={style.orderContent}>
            <Col span={2} className="titleOne">
              <div>
                <FileTextOutlined />
                <p>订单</p>
              </div>
            </Col>
            <Col span={2}>
              <Link
                to={{
                  pathname: '/orderManage/pendingDeliveryOrder',
                }}
              >
                <strong>{pendingNum?.pendingShipNum || 0}</strong>
                <p>待发货</p>
              </Link>
            </Col>
            <Col span={3}>
              <Link
                to={{
                  pathname: '/orderManage/pendingDeliveryOrder',
                  state: { status: 1 },
                }}
              >
                <strong>{pendingNum?.timeOutShipNum || 0}</strong>
                <p>超时发货{'>'}48小时</p>
              </Link>
            </Col>
            <Col span={4}>
              <Link
                to={{
                  pathname: 'cancelBillManage',
                }}
              >
                <strong>{pendingNum?.cancelOrderPendingAuditNum || 0}</strong>
                <p>取消订单审核{'<'}24小时</p>
              </Link>
            </Col>
            <Col span={2} className="titleTwo" offset={4}>
              <div>
                <FileTextOutlined />
                <p> 售后</p>
              </div>
            </Col>
            <Col span={3}>
              <Link
                to={{
                  pathname: 'afterSaleManage',
                }}
              >
                <strong>{pendingNum?.afterOrderPendingAuditNum || 0}</strong>
                <p>退款待审核{'<'}24小时</p>
              </Link>
            </Col>
          </Row>
        </div>
      </div>
    </div>
  );
};
export default Admin;
