import React from 'react';
import { Form, InputNumber, Row, Col } from 'antd';
import style from '../style/info.less';
import { validateRequired, isCheckPriceTwoDecimal } from '@/utils/validator';

const MealLimit = props => (
  <Form.Item
    label={`${props.label}限额`}
    name={props.name}
    rules={[
      { validator: validateRequired, message: `请输入${props.label}限额` },
      { validator: isCheckPriceTwoDecimal, message: '请输入正确的价格' },
    ]}
  >
    <InputNumber addonAfter="元" max={999.99} defaultValue={100} />
    {/* <Row>
      <Col span={18}>
        <Input maxLength={6} />
      </Col>
      <Col span={6}>
        <div className={style.tip}>元</div>
      </Col>
    </Row> */}
  </Form.Item>
);

export default MealLimit;
