import React from 'react';
import { Button, Form, Input, Alert, Cascader, Col, Row, Modal, Select } from 'antd';
import { layout } from '../model/index';

const CustomerInfo = props => {
  const [form] = Form.useForm();

  // 关闭分组信息弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 添加/保存分组
  const handleConfirm = async () => {};

  const extra = <Alert message="选中后，顾客下单需至少选择1个“下单必选分组”" type="error" />;

  return (
    <Modal
      title="企业客户信息"
      visible={props.visible}
      destroyOnClose
      maskClosable={false}
      width="800px"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basic" {...layout} form={form}>
        <Form.Item
          label="公司名称"
          name="name"
          rules={[{ required: true, message: '请输入公司名称!' }]}
        >
          <Input />
        </Form.Item>
        <Form.Item label="下单必选分组" name="necessary" extra={extra}>
          <Input />
        </Form.Item>
        <Form.Item
          label="企业截止时间"
          name="name"
          rules={[{ required: true, message: '请输入企业截止时间!' }]}
        >
          <Input />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default CustomerInfo;
