import React from 'react';
import { Button } from 'antd';

export const customerColumn = options => {
  const { onEdit } = options;
  return [
    {
      title: 'ID',
      dataIndex: 'name',
      width: 120,
      align: 'center',
    },
    {
      title: '公司名称',
      dataIndex: 'name',
      width: 120,
      align: 'center',
    },
    {
      title: '截单时间(分钟)',
      dataIndex: 'name',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '餐品类型',
      dataIndex: 'name',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '创建人',
      dataIndex: 'name',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '创建时间',
      dataIndex: 'createdAt',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 200,
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="edit" onClick={() => onEdit(r, 'edit')}>
          编辑
        </Button>
      ),
    },
  ];
};

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};
