import { Button, Select, Popconfirm, notification } from 'antd';
import React, { useRef, useEffect, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import lodash from 'lodash';
import styles from './index.less';
import AddrForm from './form';
import { del, query, supplier } from './services';

const { Option } = Select;

const TableList = () => {
  const [supplierList, setSupplierList] = useState([]);
  const [shopId, setShopId] = useState(null);
  const [visible, setVisible] = useState(false);
  const [formValue, setFormValue] = useState({});
  const actionRef = useRef();

  useEffect(() => {
    async function fetchData() {
      const data = await supplier();
      setSupplierList(data);
    }
    fetchData();
  }, []);
  const changeSupplier = res => {
    setShopId(res);
  };
  const reload = type => {
    if (type) {
      setShopId(null);
    }
    actionRef.current.reload();
  };
  const delAction = async ({ id }) => {
    const businessCode = await del(id);
    if (businessCode === '0000') {
      reload();
      notification.success({ message: '删除成功!' });
    }
  };
  const editAction = async row => {
    setFormValue(() => lodash.cloneDeep(row));
    setVisible(true);
  };
  const addAction = () => {
    setFormValue({});
    setVisible(true);
  };
  const onClose = res => {
    setVisible(false);
    if (res) {
      reload();
    }
  };
  const columns = [
    {
      title: '供应商名称',
      dataIndex: 'shopId',
      key: 'shopId',
      hideInTable: true,
      valueType: 'select',
      renderFormItem: () => (
        <Select onChange={changeSupplier} value={shopId} allowClear>
          {supplierList.map(item => (
            <Option value={item.id} key={item.id}>
              {item.name}
            </Option>
          ))}
        </Select>
      ),
    },
    {
      title: '供应商名称',
      dataIndex: 'supplierName',
      key: 'supplierName',
      hideInSearch: true,
    },
    {
      title: '省',
      dataIndex: 'provinceName',
      key: 'provinceName',
      hideInSearch: true,
      width: 100,
    },
    {
      title: '市',
      dataIndex: 'cityName',
      key: 'cityName',
      hideInSearch: true,
      width: 100,
    },
    {
      title: '县',
      dataIndex: 'countyName',
      key: 'countyName',
      hideInSearch: true,
      width: 100,
    },
    {
      title: '镇',
      dataIndex: 'townName',
      key: 'townName',
      hideInSearch: true,
      width: 100,
    },
    {
      title: '详细地址',
      dataIndex: 'detail',
      key: 'detail',
      hideInSearch: true,
    },
    {
      title: '收件人姓名',
      dataIndex: 'receiverName',
      key: 'receiverName',
      hideInSearch: true,
      width: 150,
    },
    {
      title: '收货人电话',
      dataIndex: 'receiverTel',
      key: 'receiverTel',
      hideInSearch: true,
      width: 150,
    },
    {
      title: '备注',
      dataIndex: 'remark',
      key: 'remark',
      hideInSearch: true,
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      render: (_, row) => [
        <Button
          key="edit"
          type="primary"
          onClick={() => {
            editAction(row);
          }}
        >
          修改
        </Button>,
        <Popconfirm
          placement="topLeft"
          title="确定要删除吗？"
          onConfirm={() => {
            delAction(row);
          }}
          okText="删除"
          cancelText="取消"
        >
          <Button key="del" type="danger" className={styles.btn}>
            删除
          </Button>
        </Popconfirm>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={styles.protable}
        actionRef={actionRef}
        columns={columns}
        params={{ shopId }}
        request={res => query(res)}
        rowKey={r => r.shopId}
        bordered
        scroll={{ x: 1500 }}
        toolBarRender={() => [
          <Button key="3" type="primary" onClick={addAction}>
            添加售后地址
          </Button>,
        ]}
        onReset={() => reload('reset')}
      />
      <AddrForm
        visible={visible}
        supplierList={supplierList}
        value={formValue}
        onClose={onClose}
      ></AddrForm>
    </PageHeaderWrapper>
  );
};

export default TableList;
