import React, { useState, useEffect } from 'react';
import { Checkbox, Space, Modal, notification, message } from 'antd';
import { mealColumn } from '../staticData/goods';
import { apiMealInfoUpdate, apiEnterpriseInfo, apiCheckInfo } from '../service';

const SaleDateModal = props => {
  const [value, setValue] = useState([]);
  const [loading, setLoading] = useState(false);
  const [tabCateList, setTabCateList] = useState(Object.keys(mealColumn));

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeMeal = e => {
    setValue(e);
  };

  // 提交
  const handleConfirm = async () => {
    if (!value || value.length < 1) {
      message.error('请选择餐段');
      return;
    }
    if (props.productType === 4) {
      const data = [];
      props.dataSource.forEach(item => {
        const obj = {
          saleDateList: item.saleDate,
          tabCateList: item.tabCate?.map(v => ({ tabId: v })),
        };
        if (props.item.skuId === item.skuId && item.saleDate) {
          obj.tabCateList = value.map(v => ({ tabId: v }));
          data.push(obj);
        } else if (item.saleDate?.length && item.tabCate?.length) {
          data.push(obj);
        }
      });
      const res = await apiCheckInfo(data);
      if (!res || !res.success) {
        return;
      }
    }
    if (props.id) {
      const params = {
        id: props.id,
        tabIds: value,
      };
      await apiMealInfoUpdate(params);
      notification.success({ message: '保存成功' });
    }
    handleCancel();
    props.handleRefresh(value);
  };

  // 获取店铺餐段通过企业ID
  const getEnterpriseMealColumn = async () => {
    setLoading(true);
    const res = await apiEnterpriseInfo(props.enterpriseID);
    setLoading(false);
    if (res && res.data && res.data.mealTimePeriod && res.data.mealTimePeriod.length) {
      const arr = res.data.mealTimePeriod.map(item => `${item.mealPeriodType}`);
      setTabCateList(arr);
      setValue(arr);
    }
  };

  useEffect(() => {
    if (props.visible) {
      let v = [];
      let tabCate = [];
      if (props.item) {
        if (props.type) {
          tabCate = props.item[props.type];
        }
        tabCate = tabCate || props.item.tabCateList || props.item.tabCate;
      }
      if (tabCate && tabCate.length) {
        v = tabCate.map(item => {
          if (typeof item === 'object') {
            return `${item.tabId}`;
          }
          return `${item}`;
        });
      }
      setValue(v);
      if (props.enterpriseID) {
        getEnterpriseMealColumn();
      }
    }
  }, [props.visible]);

  return (
    <Modal
      title={props.title || '设置可售餐段'}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="200px"
      okText="保存"
      confirmLoading={loading}
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Checkbox.Group onChange={onChangeMeal} value={value}>
        <Space direction="vertical">
          {tabCateList.map(key => (
            <Checkbox key={key} value={key}>
              {mealColumn[key]}
            </Checkbox>
          ))}
        </Space>
      </Checkbox.Group>
    </Modal>
  );
};
export default SaleDateModal;
