import debounce from 'lodash/debounce';
import { apiEnterpriseList, apiShopList, apiShopListByPickSelfID } from './index';

// 获取企业列表
export const getEnterpriseList = async (name = '') => {
  const res = await apiEnterpriseList({ name });
  return {
    id: res[res.length - 1].id,
    list: res.map(item => ({
      [item.id]: { text: item.name },
    })),
  };
};
// 获取店铺列表
export const getShopList = debounce(async e => {
  const { name } = e;
  const res = await apiShopList({ name });
  return {
    id: res[res.length - 1].id,
    list: res.map(item => ({
      [item.id]: { text: item.name },
    })),
  };
}, 300);
// 获取店铺列表通过自提点ID
export const getShopListByPickSelf = async e => {
  const { name } = e;
  const res = await apiShopListByPickSelfID({ name });
  return {
    id: res[res.length - 1].id,
    list: res.map(item => ({
      [item.id]: { text: item.name },
    })),
  };
};
