import React from 'react';
import { Modal, Form, Input, Checkbox, message } from 'antd';
import styles from '../index.less';
import { apiStaffBlack } from '../service';

const { Item } = Form;

const BlacklistModal = ({ visible, onClose, list, enterpriseId }) => {
  const [form] = Form.useForm();

  const handleSave = () => {
    form.validateFields().then(values => {
      const params = {
        enterpriseId,
        ids: list,
        isBlack: 1,
        balanceBackFlag: 1,
      };
      apiStaffBlack(params).then(res => {
        if (res.businessCode === '0000') {
          message.success('设置成功');
          onClose(true, 'blacklist');
        }
      });
    });
  };

  return (
    <Modal
      visible={visible}
      title="设置员工黑名单"
      onCancel={() => onClose(false, 'blacklist')}
      onOk={handleSave}
    >
      <Form form={form} layout="vertical">
        <Item name="ids" label="您确定要把员工ID:">
          {list.length && list.map(item => <span>{item},</span>)}
        </Item>
        <Item name="reason" label="加入黑名单吗？">
          <div className={styles.blackList}>
            <Checkbox defaultChecked disabled></Checkbox>
            <div className={styles.left}>
              <span>请确定要回收员工账户内的剩余余额&餐券吗？ </span>
              <br />
              <span>(勾选则回收，不勾选则不回收。)</span>
            </div>
          </div>
        </Item>
      </Form>
    </Modal>
  );
};

export default BlacklistModal;
