import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import config from '../../../../config/env.config';

// 待发货订单
export async function queryToSend(params) {
  const transformedParam = {
  	...params,
    logisticsStatus: params.logisticsStatus ? params.logisticsStatus.slice(1) : '',
    startTime: params.beginTime,
  	pageNo: params.current,
    pageSize: params.pageSize || 20,
  };
  
  const { data: { current, records, total, size } } = await request.post('/api/kdsp/op/mch-order/list', {
    prefix: config.kdspApi,
    data: stringify(_.omitBy(transformedParam, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    }
  });
  return {
    current: current,
    data: records.map(v => ({...v, logisticsStatus: `_${v.logisticsStatus}`})),
    total: total,
    pageSize: size
  }
}

// 快递公司
export async function queryExpress() {
	 const { data } = await request.get('/api/kdsp/op/express/list', {
     prefix: config.kdspApi,
   });
   return data;
}

export async function updateExpress(params) {
  return request.post('/api/kdsp/op/mch-order/update-express-info', {
    prefix: config.kdspApi,
    data: params
  });
}

export async function getGoods(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}