const isProduction = process.env.NODE_ENV === 'production';
const isPre = process.env.PRE_ENV === 'pre';

const envAPi = {
  api: '//backstms-test1.liangkebang.net',
  kdspOpApi: 'https://kdsp-operation-test1.liangkebang.net',
  kdspApi: 'https://sc-op-api-test1.liangkebang.net',
  goodsApi: 'https://sc-op-api-test1.liangkebang.net',
  // goodsApi: '//192.168.28.107:7000',
  prologueDomain: 'https://prologue-test1.liangkebang.net',
  qiniuHost: 'https://appsync.lkbang.net',
  opapiHost: 'https://opapi-test1.liangkebang.net',
};

const prodApi = {
  api: '//backstms.q-gp.com',
  kdspOpApi: '//kdsp-operation.q-gp.com',
  prologueDomain: '//prologue.q-gp.com',
  kdspApi: '//sc-op-api.q-gp.com',
  // goodsApi: 'https://sc-op-api.q-gp.com', // 测试环境打包域名，
  goodsApi: 'https://sc-merchant-api.q-gp.com', // 线上环境打包域名
  qiniuHost: 'https://appsync.lkbang.net',
  opapiHost: 'https://opapi.xyqb.com',
};

const preProdApi = {
  api: '//backstms-pre.xyqb.com',
  kdspOpApi: '//kdsp-operation-pre.q-gp.com',
  prologueDomain: '//prologue.q-gp.com',
  kdspApi: '//sc-op-api-pre.q-gp.com',
  goodsApi: 'https://sc-merchant-api.q-gp.com', // 线上环境打包域名
  qiniuHost: 'https://appsync.lkbang.net',
  opapiHost: 'https://opapi-pre.q-gp.com',
};

const exportApi = envAPi;
if (isPre) {
  exportApi = preProdApi;
} else if (isProduction) {
  exportApi = prodApi;
}
module.exports = exportApi;
// let exportApi;
// isProduction ? (exportApi = prodApi) : (exportApi = envAPi);

// export default exportApi;
