import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, kdspApi } = config;
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};

export const merchantUpload = async files => {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

export const getProductDetail = id =>
  request.post('/product/api/merchant/detail', {
    prefix: goodsApi,
    params: { id },
    headers,
  });

export const merchantCategoryGetAll = () =>
  request.post('/product/category/api/merchant/getAll', {
    prefix: goodsApi,
  });

// 获取商品品牌
export const merchantBrandList = () =>
  request.post('/product/brand/api/merchant/list', {
    prefix: goodsApi,
  });
// export const merchantBrandList = () =>
//   request.post('/api/merchants/brands/getAll', {
//     prefix: goodsApi,
//   });

// 获取规格列表
export const merchantSpecList = () =>
  request.post('/product/spec/api/merchant/list', {
    prefix: goodsApi,
  });

// 查询供应商售后地址
export const afterSalesAddrsPage = () => {
  const params = {
    pageSize: 100,
    pageNo: 1,
  };
  const data = request.post('/api/merchants/aftersales/addresses/list', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
};

export const merchantgetJdPicList = async params => {
  const { data } = await request.post('/product/api/merchant/item/getJdPicList', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
  return data;
};

export const merchantProductAdd = data =>
  request.post('/api/merchants/products/add', {
    prefix: goodsApi,
    data,
  });

export const merchantProductEdit = data =>
  request.post('/product/api/merchant/edit', {
    prefix: goodsApi,
    data,
  });

export const supplierListQuery = () =>
  request.get('/api/merchants/suppliers/querylist', {
    prefix: config.kdspApi,
    headers,
  });

// supplierId: 供应商id(优先使用token中的supplierId,这里可以传任意值，建议传0)
// state: 状态:-1-全部，1-启用，0-禁用
// export const shopGetBySupplierId = (state = 1, supplierId = 0) =>
//   request.get(`/shop/getBySupplierId/${supplierId}/${state}`, {
//     prefix: goodsApi,
//     headers,
//   });
export const shopGetBySupplierId = (productBusiness, state = 1) =>
  request.get(
    `/api/merchants/shops/getBySupplierId?${stringify({
      state,
      productBusiness,
    })}`,
    {
      prefix: goodsApi,
      headers,
    },
  );
export const getByProductType = type =>
  request.get(`/product/category/getByProductType/${type}`, {
    prefix: goodsApi,
    headers,
  });

// 获取类目关联属性
export const apiGetAttribute = categoryId =>
  request.get(`/api/kdsp/category/template/ref/attribute/detail?categoryId=${categoryId}`, {
    prefix: goodsApi,
  });

// 新建草稿
export const apiCreateDraft = data =>
  request.post('/api/merchants/drafts/add', {
    prefix: goodsApi,
    data,
  });

// 编辑草稿
export const apiEditDraft = data =>
  request.post('/api/merchants/drafts/edit', {
    prefix: goodsApi,
    data,
  });

// 菜单分组 http://yapi.quantgroups.com/project/389/interface/api/64044
export const apiQueryShopList = data =>
  request.post('/api/merchants/products/storageRack/listByShopIdAndStorageRackIds', {
    prefix: goodsApi,
    data: stringify(_.omitBy(data, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
// 新建分组
export const apiCreateShop = data =>
  request.post('/api/merchants/products/storageRack/create', {
    prefix: goodsApi,
    data,
  });
// 商品标签列表 http://yapi.quantgroups.com/project/389/interface/api/57979
export const apiTagList = data =>
  request.post('/api/merchants/products/tag/getAll', {
    prefix: goodsApi,
    data,
  });
// 单位列表 http://yapi.quantgroups.com/project/389/interface/api/57179
export const apiUnits = data =>
  request.get('/api/merchants/products/units', {
    prefix: goodsApi,
    data,
  });
// 获取shopids http://yapi.quantgroups.com/project/389/interface/api/38056
export const apiShopIds = data =>
  request.get('/api/merchants/shops/getBySupplierId?state=1&productBusiness=1', {
    prefix: goodsApi,
    data,
  });

// 获取店铺详情 http://yapi.quantgroups.com/project/389/interface/api/57589
export const apiGetShopDetail = data =>
  request.post('/api/merchants/products/sku-detail', {
    prefix: goodsApi,
    data: stringify(_.omitBy(data, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });

/**
 * 获取类目关联服务
 * yApi地址: http://yapi.quantgroups.com/project/389/interface/api/69189
 * */
export const apiServiceByCategory = (categoryId, refIdType = 1) =>
  request.get(
    `/api/merchants/products/service/config/list?refId=${categoryId}&refIdType=${refIdType}`,
    {
      prefix: goodsApi,
    },
  );
