import React from 'react';
import { Modal, Form, Input } from 'antd';

const MinimumPurchase = options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
    options.confirm({
      type: 5,
      ...values,
    });
  };

  return (
    <Modal
      visible={options.visible}
      title="修改最少购买数量"
      onOk={handleOk}
      maskClosable={false}
      keyboard={false}
      confirmLoading={options.loading}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        autoComplete="off"
      >
        <Form.Item
          label="最少购买/份"
          name="minPurchaseNum"
          rules={[
            { required: true, message: '请输入最少购买数量!' },
            { min: 1, message: '最小输入1' },
          ]}
        >
          <Input maxLength={6} type="number" />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default MinimumPurchase;
