import React from 'react';
import { Modal, Form, Radio } from 'antd';

const SendModal = options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
    options.confirm({
      type: 6,
      ...values,
    });
  };

  const radioOptions = [{ label: '单点送', value: 1 }, { label: '单点不送', value: 0 }];
  const initialValues = Object.assign({}, options.initialValues);

  return (
    <Modal
      visible={options.visible}
      title="设置单点不送"
      onOk={handleOk}
      maskClosable={false}
      keyboard={false}
      confirmLoading={options.loading}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label="是否单点不送"
          name="isSingleDelivery"
          rules={[{ required: true, message: '请选择!' }]}
        >
          <Radio.Group options={radioOptions} />
        </Form.Item>
      </Form>
      <div>开启后顾客单点这些商品不可下单</div>
    </Modal>
  );
};

export default SendModal;
