import React, { useState, useEffect } from 'react';
import { Form, Checkbox, Space, Modal, notification, message } from 'antd';
import { mealColumn } from '../staticData/goods';
import { apiMealInfoUpdate } from '../service';

const SaleDateModal = props => {
  const [form] = Form.useForm();
  const [value, setValue] = useState([]);

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeMeal = e => {
    setValue(e);
  };

  // 提交
  const handleConfirm = async () => {
    if (!value || value.length < 1) {
      message.error('请选择餐段');
      return;
    }
    if (props.id) {
      const params = {
        id: props.id,
        tabIds: value,
      };
      await apiMealInfoUpdate(params);
      notification.success({ message: '保存成功' });
    }
    handleCancel();
    props.handleRefresh(value);
  };

  useEffect(() => {
    if (props.visible) {
      setValue([]);
    }
  }, [props.visible]);

  return (
    <Modal
      title={props.title || '修改可售餐段'}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="200px"
      okText="保存"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Checkbox.Group onChange={onChangeMeal} value={value}>
        <Space direction="vertical">
          {Object.keys(mealColumn).map(key => (
            <Checkbox value={key}>{mealColumn[key]}</Checkbox>
          ))}
        </Space>
      </Checkbox.Group>
    </Modal>
  );
};
export default SaleDateModal;
