import React from 'react';
import { Button, Space, Switch } from 'antd';
import { FormOutlined } from '@ant-design/icons';
import { jsonToArray } from '@/utils/utils';
import { getShopList } from '../service/bll';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};
// 0-推荐 1-早餐 2-午餐 3-下午茶 4-晚餐
export const mealColumn = {
  // 0: '推荐',
  1: '早餐',
  2: '午餐',
  // 3: '晚餐',
  4: '晚餐',
};

// 商品类型
export const productType = {
  1: '实物商品',
  2: '虚拟商品',
  // 3: '电子卡券'（废弃）
  4: '服务类商品',
  5: '外卖商品',
};

// 餐品类型：（1外卖 2 自助餐 4到店）
export const mealType = {
  1: '外卖',
  2: '自助餐',
  4: '到店',
};

export const weekOptions = {
  1: '周一',
  2: '周二',
  3: '周三',
  4: '周四',
  5: '周五',
  6: '周六',
  7: '周日',
};

export const takeawayGoodsColumn = options => {
  const {
    onDel,
    onChangeFlag,
    setVisibleSaleDate,
    enterprises,
    setRecordID,
    setVisiblePrice,
    setVisibleSaleSection,
    setVisibleSort,
    onChangeEnterprise,
  } = options;
  return [
    {
      title: '企业名称',
      dataIndex: 'enterpriseId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: (v, option) => (option?.label ?? '').toLowerCase().includes(v.toLowerCase()),
        onChange: onChangeEnterprise,
      },
      valueEnum: enterprises,
    },
    {
      title: '微店名称',
      dataIndex: 'shopId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: false,
        // onSearch: getShopList,
      },
      request: getShopList,
      valueEnum: {},
    },
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 170,
      align: 'center',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: '商品图片',
      dataIndex: 'primaryImage',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueType: 'image',
    },
    {
      title: '可售日期',
      dataIndex: 'saleDateList',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length && (
            <div>
              {_.length === 7 ? '不限制' : <span>{_.map(item => item.name).join('/')}</span>}
            </div>
          )}
          <span
            onClick={() => {
              setRecordID(record.id);
              setVisibleSaleDate(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '可售餐段',
      dataIndex: 'tabCateList',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length && <span>{_.map(item => item.tabName).join('/')}</span>}
          <span
            onClick={() => {
              setRecordID(record.id);
              setVisibleSaleSection(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '企业价格',
      dataIndex: 'activityPrice',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span
            onClick={() => {
              setRecordID(record.id);
              setVisiblePrice(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '商品销售价',
      dataIndex: 'price',
      width: 100,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '状态',
      dataIndex: 'status',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueEnum: {
        1: '已上架',
        2: '已下架',
        3: '已售罄',
      },
    },
    {
      title: '排序',
      dataIndex: 'sort',
      width: 90,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span
            onClick={() => {
              setRecordID(record.id);
              setVisibleSort(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '列出商品',
      dataIndex: 'showFlag',
      align: 'center',
      width: 100,
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>
            <Switch checked={+_ === 1} onChange={e => onChangeFlag(record.id, e)} />
          </span>
        </Space>
      ),
    },
    {
      title: '餐品类型',
      dataIndex: 'mealTypeList',
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: '添加时间',
      dataIndex: 'createDate',
      valueType: 'dateRange',
      align: 'center',
      render(v, record) {
        return record.createDate;
      },
    },
    {
      title: '当日餐段',
      dataIndex: 'tabId',
      align: 'center',
      valueEnum: mealColumn,
      hideInTable: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r.id)}>
          删除
        </Button>
      ),
    },
  ];
};

export const GoodsInfoColumn = options => {
  const { onDel, setVisibleSaleDate, setVisibleSaleSection, setEditID, setVisiblePrice } = options;
  return [
    {
      title: '微店名称',
      dataIndex: 'shopName',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: '商品售价',
      dataIndex: 'salePrice',
      width: 120,
      align: 'center',
    },
    {
      title: '企业价格',
      dataIndex: 'enterprisePrice',
      width: 120,
      align: 'center',
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span
            onClick={() => {
              setEditID(record.skuId);
              setVisiblePrice(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '库存',
      dataIndex: 'stock',
      width: 120,
      align: 'center',
      render(v, record) {
        const arr = record.supplierProductItemList;
        if (arr && arr.length) {
          return arr[0].stock;
        }
        return '-';
      },
    },
    {
      title: '可售日期',
      dataIndex: 'saleDate',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ &&
            (_.length === 7 ? '不限制' : <span>{_.map(item => weekOptions[item]).join('/')}</span>)}
          <span
            onClick={() => {
              setEditID(record.skuId);
              setVisibleSaleDate(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '可售餐段',
      dataIndex: 'tabCate',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_ && _.map(item => mealColumn[item]).join('/')}</span>
          <span
            onClick={() => {
              setEditID(record.skuId);
              setVisibleSaleSection(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '餐品类型',
      dataIndex: 'mealTypeList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r, i) => (
        <Button key="del" onClick={() => onDel(i)}>
          删除
        </Button>
      ),
    },
  ];
};

export const SelectGoodsColumn = [
  {
    title: '商品ID',
    width: 120,
    align: 'center',
    dataIndex: 'skuId',
  },
  {
    title: '商品名称',
    dataIndex: 'skuName',
  },
  // {
  //   title: '商品编号',
  //   dataIndex: 'skuNo',
  //   width: 120,
  //   align: 'center',
  // },
  {
    title: '销售价',
    dataIndex: 'salePrice',
    width: 120,
    align: 'center',
  },
  {
    title: '剩余库存',
    dataIndex: 'stock',
    width: 100,
    align: 'center',
    render(v, record) {
      const arr = record.supplierProductItemList;
      if (arr && arr.length) {
        return arr[0].stock;
      }
      return '-';
    },
  },
  {
    title: '已参与活动',
    dataIndex: 'activity',
    align: 'center',
    width: 110,
    hideInSearch: true,
  },
];

// 企业虚拟商品列表字段
export const virtualGoodsColumn = options => {
  const { onDel, enterprises, onChangeEnterprise } = options;
  return [
    {
      title: '企业名称',
      dataIndex: 'enterpriseId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: (v, option) => (option?.label ?? '').toLowerCase().includes(v.toLowerCase()),
        onChange: onChangeEnterprise,
      },
      valueEnum: enterprises, // companyEnum,
    },
    {
      title: '微店名称',
      dataIndex: 'shopId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: false,
        // onSearch: getShopList,
      },
      request: getShopList,
      valueEnum: {}, // shopEnum,
    },
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 160,
      align: 'center',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: '商品图片',
      dataIndex: 'primaryImage',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueType: 'image',
    },
    {
      title: '可售日期',
      dataIndex: 'saleDateList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length && (
            <div>
              {_.length === 7 ? '不限制' : <span>{_.map(item => item.name).join('/')}</span>}
            </div>
          )}
        </Space>
      ),
    },
    {
      title: '可售餐段',
      dataIndex: 'tabCateList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>{_ && _.length && <span>{_.map(item => item.tabName).join('/')}</span>}</Space>
      ),
    },
    {
      title: '企业价格',
      dataIndex: 'activityPrice',
      width: 100,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
        </Space>
      ),
    },
    {
      title: '商品销售价',
      dataIndex: 'price',
      width: 100,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '状态',
      dataIndex: 'status',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueEnum: {
        1: '已上架',
        2: '已下架',
        3: '已售罄',
      },
    },
    {
      title: '餐品类型',
      dataIndex: 'mealTypeList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: '添加时间',
      dataIndex: 'createDate',
      width: 120,
      valueType: 'dateRange',
      align: 'center',
      render(v, record) {
        return record.createDate;
      },
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r.id)}>
          删除
        </Button>
      ),
    },
  ];
};
