import React from 'react';
import { Modal, Table } from 'antd';

const RechargeDetailsModal = ({ visible, onClose, list }) => {
  const columns = [
    {
      title: '员工ID',
      dataIndex: 'staffNo',
      key: 'staffNo',
      align: 'center',
    },
    {
      title: '员工姓名',
      dataIndex: 'staffName',
      key: 'staffName',
      align: 'center',
    },
    {
      title: '充值余额',
      dataIndex: 'rechargeAmount',
      key: 'rechargeAmount',
      align: 'center',
    },
    {
      title: '充值时间',
      dataIndex: 'generateDate',
      key: 'generateDate',
      align: 'center',
    },
  ];

  return (
    <Modal
      width="800px"
      visible={visible}
      title="充值明细"
      onCancel={() => onClose(false, 'rechargeDetails')}
      footer={null}
    >
      <Table dataSource={list} columns={columns} pagination={false} bordered />
    </Modal>
  );
};

export default RechargeDetailsModal;
