// import React, { useState, useRef, useEffect } from 'react';
// import ProTable from '@ant-design/pro-table';
// import { PageHeaderWrapper } from '@ant-design/pro-layout';
// import { columns, auditStatusValueEnum } from './staticdata';
// import { accountApplyList, accountApplyDetail } from './service';
// import ExamineFormModal from './ExamineFormModal';
// import styled from './index.less';
// import { getAppChannelAllList } from '@/services/common';

// /**
//  * 渠道管理-审批记录 和 财务管理-资金审核
//  * 共用一个页面
//  * @param {*} router options
//  * @returns ReactDOM
//  */
// const CapitalExamine = ({ route }) => {
//   const isAudit = route.name === 'capitalExamine'; // 是否时资金审核页面
//   const ref = useRef();
//   const actionRef = useRef();
//   const [examVisible, setExamVisible] = useState(false);
//   const [examLoading, setExamLoading] = useState(false);
//   const [channelAllList, setChannelAllList] = useState({});
//   const search = {
//     collapsed: false,
//     collapseRender: () => null,
//   };

//   const query = async param => {
//     const timeArray = param?.createdAt;
//     if (timeArray?.length) {
//       const [createdStartAt, createdEndAt] = timeArray;
//       param.createdStartAt = createdStartAt;
//       param.createdEndAt = createdEndAt;
//       delete param.createdAt;
//     }
//     const [data] = await accountApplyList(param);
//     return {
//       total: data.total,
//       data: data?.records,
//     };
//   };

//   const openExamineFormModal = async (row, audit) => {
//     setExamLoading(true);
//     const [data, error] = await accountApplyDetail(row.id);
//     if (!error) {
//       data.audit = !!audit;
//       data.auditStatusName = auditStatusValueEnum[data.auditStatus].text;
//       actionRef.current.setDetailData(data);
//       setExamVisible(true);
//     }
//     setExamLoading(false);
//   };

//   const closeExamineFormModal = () => {
//     setExamVisible(false);
//   };

//   const columsOptions = {
//     isAudit,
//     openExamineFormModal,
//     channelAllList,
//   };
//   // 获取所有渠道
//   const getChannelAllList = async () => {
//     const [data] = (await getAppChannelAllList()) || [];
//     const list = {};
//     if (data) {
//       data.forEach(item => {
//         list[item.id] = item.name;
//       });
//       setChannelAllList(list);
//     }
//   };

//   const refreshTable = () => {
//     ref.current.reload();
//   };

//   useEffect(() => {
//     getChannelAllList();
//   }, []);
//   const onReset = () => {};

//   return (
//     <PageHeaderWrapper>
//       <ProTable
//         bordered
//         loading={examLoading}
//         type="cardList"
//         request={query}
//         className={styled.tableProName}
//         tableClassName="capital"
//         columns={columns(columsOptions, 'parent')}
//         rowKey={(_, index) => index}
//         search={search}
//         options={false}
//         actionRef={ref}
//         toolBarRender={false}
//         pagination={{
//           pageSize: 10,
//         }}
//         onReset={onReset}
//         // toolBarRender={[]}
//         scroll={{ x: '100%', y: 430 }}
//       ></ProTable>
//       <ExamineFormModal
//         refresh={refreshTable}
//         examVisible={examVisible}
//         wrappedComponentRef={actionRef}
//         closeExamineFormModal={closeExamineFormModal}
//       />
//     </PageHeaderWrapper>
//   );
// };

// export default CapitalExamine;
