import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Select, Cascader, Tag, notification } from 'antd';
import { da } from 'date-fns/locale';
import React, { useState, useEffect } from 'react';
import { getTemplate, getAfterAddress } from '../service';

const { Option } = Select;

const TempleatModal = props => {
  const {
    visible,
    form: { getFieldDecorator, validateFields, resetFields },
    selectedRowKeys,
    templateList,
    isALL,
    isType,
  } = props;
  const formItemLayout = {
    labelCol: {
      span: 5,
    },
    wrapperCol: {
      span: 16,
    },
  };
  const handleOk = async () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        if (isType === 'distribution') {
          this.setAfterAddress(fieldsValue);
        }
        if (isType === 'after') {
          this.setTemplate(fieldsValue);
        }
      }
    });
  };
  const setAfterAddress = async fieldsValue => {
    const data = await getAfterAddress({
      // isAll: isALL,
      skuIds: selectedRowKeys,
      afterAddressId: fieldsValue.templateId.key,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: '配置成功！' });
      resetFields();
      props.onCancel();
    }
  };
  const setTemplate = async fieldsValue => {
    const data = await getTemplate({
      isAll: isALL,
      skuIdList: selectedRowKeys,
      templateId: fieldsValue.templateId.key,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: '配置成功！' });
      resetFields();
      props.onCancel();
    }
  };

  const title = () => {
    if (isType === 'distribution') {
      if (isALL) {
        return '全部商品配送区域设置';
      }
      return '勾选商品配送区域设置';
    }
    if (isType === 'after') {
      if (isALL) {
        return '全部设置不支持配送区域';
      }
      return '批量设置不支持配送区域';
    }
    return '';
  };

  useEffect(() => {}, []);
  return (
    <Modal
      title={title}
      visible={visible}
      width="500px"
      onCancel={props.onCancel}
      onOk={() => handleOk()}
    >
      {!isALL && <p>已选择{selectedRowKeys.length}个商品</p>}
      <Form {...formItemLayout}>
        <Form.Item label="选择模板">
          {getFieldDecorator('templateId', {
            rules: [{ required: true, message: '请选择模板!' }],
          })(
            <Select placeholder="请选择模板" labelInValue allowClear>
              {isType === 'after' &&
                templateList.map(item => (
                  <Option label={item.templateName} value={item.id} key={item.id}>
                    {item.templateName}
                  </Option>
                ))}
              {isType === 'distribution' &&
                templateList.map(item => (
                  <Option label={item.addressName} value={item.id} key={item.id}>
                    {item.addressName}
                  </Option>
                ))}
            </Select>,
          )}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(TempleatModal);
