import { PlusOutlined } from '@ant-design/icons';
import { Upload, Modal, notification } from 'antd';
import React from 'react';
import config from '../../../config/env.config';
import { qiniuToken } from '@/services/qiniu';

const qiniu = require('@/utils/qiniu.min.js');

const { qiniuHost } = config;
function getBase64(file) {
  return new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.readAsDataURL(file);
    reader.onload = () => resolve(reader.result);
    reader.onerror = error => reject(error);
  });
}
let token = null;

class PicturesWall extends React.Component {
  state = {
    previewVisible: false,
    previewImage: '',
    fileList: [],
  };

  async componentDidMount() {
    this.initFileList(this.props.fileList || []);
    token = await qiniuToken();
  }

  static getDerivedStateFromProps(nextProps) {
    new PicturesWall(nextProps).initFileList();
    return null;
  }

  initFileList = fileList => {
    const fileLists =
      fileList?.map((item, index) => ({
        url: item,
        name: '',
        uid: index,
        status: 'done',
      })) || [];
    this.setState({ fileList: fileLists });
  };

  handleCancel = () => this.setState({ previewVisible: false });

  handlePreview = async file => {
    const fileC = file;
    if (!file.url && !file.preview) {
      fileC.preview = await getBase64(file.originFileObj);
    }

    this.setState({
      previewImage: fileC.url || fileC.preview,
      previewVisible: true,
    });
  };

  handleChange = ({ fileList }) => {
    const file = fileList.filter(item => item.url);
    this.setState({ fileList: [...file] });
    const urlList = file.map(item => item.url);
    this.props.onChange(urlList);
  };

  imageSize = async file =>
    new Promise((resolve, reject) => {
      const fileObj = file;
      // 获取上传的图片的宽高
      const reader = new FileReader();
      reader.readAsDataURL(fileObj);
      reader.onload = evt => {
        const replaceSrc = evt.target.result;
        const imageObj = new Image();
        imageObj.src = replaceSrc;
        imageObj.onload = () => {
          const { width } = imageObj;
          const { height } = imageObj;
          file.width = width;
          file.height = height;
          resolve(file);
        };
      };
      reader.onerror = error => reject(error);
    });

  customRequest = async ({ file, onError, onSuccess }) => {
    const imgSize = await this.imageSize(file);
    const vm = this;
    const observable = qiniu.upload(file, null, token);
    const observer = {
      next() {
        // ...
      },
      error() {
        onError(file);
        // ...
      },
      complete(res) {
        const comFile = file;
        const url = `${qiniuHost}/${res.hash}`;
        comFile.url = url;
        const list = vm.state.fileList;
        list.push({
          url: file.url,
          name: file.name,
          uid: list.length,
          status: 'done',
        });
        vm.setState({ fileList: [...list] });
        const urlList = list.map(item => item.url);
        vm.props.onChange(urlList);

        onSuccess(comFile);
        // ...
      },
    };
    observable.subscribe(observer); // 上传开始
  };

  getFileList = () => {
    const fileList = this.state.fileList.map(item => item.response?.url);
    return fileList;
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  render() {
    const { previewVisible, previewImage, fileList } = this.state;
    const uploadButton = (
      <div>
        <PlusOutlined />
        <div className="ant-upload-text">上传图片</div>
      </div>
    );
    const { max } = this.props;

    return (
      <div className="clearfix">
        <Upload
          {...this.props}
          customRequest={this.customRequest}
          listType="picture-card"
          fileList={fileList}
          onPreview={this.handlePreview}
          onChange={this.handleChange}
          multiple
        >
          {max && fileList.length >= max ? null : uploadButton}
        </Upload>
        <Modal visible={previewVisible} footer={null} onCancel={this.handleCancel}>
          <img alt="example" style={{ width: '100%' }} src={previewImage} />
        </Modal>
      </div>
    );
  }
}
export default PicturesWall;
