import React, { useContext } from 'react';
import { TaskList } from '../config';
import { ServiceContext } from '../context';
import commonStyle from '../common.less';

export const TaskTypeSelect = props => {
  const customer = useContext(ServiceContext);
  const typeConfig = TaskList(
    customer.canAddService,
    customer.canAddNormal,
    customer.canTakeawayService,
  );
  const selectTabs = task => {
    if (!customer.isEdit && Object.keys(props.takeAway).length === 0) {
      props.onChange(task);
    }
  };

  return (
    <div className={commonStyle.prodcutContent}>
      {typeConfig.map(task => {
        const activeClassName = props.productType === task.type ? commonStyle.activeCard : '';
        if (task.hide) return null;
        return (
          <dl
            key={task.type}
            onClick={() => selectTabs(task)}
            className={`${commonStyle.productCard} ${activeClassName}`}
          >
            <dd className="prodcut-name">{task.name}</dd>
            <dd className="prodcut-desc">({task.desc})</dd>
          </dl>
        );
      })}
    </div>
  );
};
