import React, { Component } from 'react';
import { history } from 'umi';
import moment from 'moment';
import { ArrowRightOutlined, UploadOutlined } from '@ant-design/icons';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import {
  Select,
  Input,
  Radio,
  Checkbox,
  DatePicker,
  Upload,
  Button,
  Card,
  Row,
  Col,
  Cascader,
  notification,
  Spin,
  Tabs,
} from 'antd';
import styles from './style.less';
import {
  wrapperCol,
  uploadPropsFn,
  formItemLayout,
  renderServiceTags,
  loadData,
  getAreaAddr,
  getServiceFacility,
  businessModel,
  getInfo,
  getBankList,
  businessTypeDesc,
} from './data';
import { validatePhone, validateEMail, validNumber } from '@/utils/validator';
import { getErrorMessage } from '@/utils/utils';
import MapModal from '@/components/BaiduMap';
import { apiCategoryList, apiEditStoreInfo, apiRecognize, apiRevision } from '../service';
import {
  infoTypeFind,
  infoTypeChecked,
  infoTypeEdit,
  infoTypeRevision,
  infoTypeInfo,
} from '../staticdata';

const { Option } = Select;
const { Item: FormItem } = Form;
const { RangePicker } = DatePicker;
const { TabPane } = Tabs;

class BusinessInfo extends Component {
  getFieldDecorator = this.props?.form?.getFieldDecorator;

  setFieldsValue = this.props?.form?.setFieldsValue;

  state = {
    id: null,
    type: infoTypeFind,
    businessInfo: {
      customList: [],
      settlementType: 1,
      companyType: '',
    },
    areaAddr: [], // 四级地址列表
    categoryList: [], // 主要类目
    serviceFacilitys: [], // 服务设施
    bankList: [], // 开户行
    // eslint-disable-next-line react/no-unused-state
    tagVisible: false,
    // eslint-disable-next-line react/no-unused-state
    tagValue: '',
    settlementType: 1,
    loading: false,
    visibleMap: false,
    visibleLoading: false,
    calculateType: [1, 1],
    checkboxDisabled: false,
    mainCategoryId: null,
    companyNamedis: false, // 公司名称
    bankAccounts: false,
  };

  async componentDidMount() {
    getAreaAddr.call(this);
    getInfo.call(this);
    getServiceFacility.call(this);
    getBankList.call(this);
    if (this.state.businessInfo.productBusiness) {
      this.getCategoryList(this.state.businessInfo.productBusiness);
    }
  }

  // 主营类目
  onMainCategory(e) {
    this.setState({
      mainCategoryId: e,
    });
  }

  // 长期
  oncheckedChange = e => {
    this.setState({
      checkboxDisabled: e.target.checked,
    });
    this.props.form.setFieldsValue({
      legalPerson: '',
    });
  };

  // eslint-disable-next-line react/sort-comp
  getDataInfo = type => ({
    key: type,
    name: businessTypeDesc[type],
    chargeMethod: 1,
    calculateType: 1,
  });

  // 计费类型改变
  onChangeCalculateType = (e, i) => {
    this.setState(state => {
      const { calculateType } = state;
      calculateType[i] = +e;
      return {
        calculateType,
      };
    });
  };

  static getDerivedStateFromProps() {
    return null;
  }

  // 帐号类型切换
  onChangeSettlType(e) {
    this.setState({
      settlementType: e.target.value,
    });
  }

  // 处理图片
  dealImgInfo = async (type, url) => {
    const imgType = {
      businessLicenseImage: 2,
      idCardPortraitImage: 5,
      idCardEmblemImage: 4,
    };
    if (!url) {
      return;
    }
    this.setState({
      visibleLoading: true,
    });
    const data = await apiRecognize({
      imageUrl: url,
      imageType: imgType[type],
    });
    if (data.businessCode === '0000') {
      const res = data.data;
      const info = {};
      this.setState(state => {
        if (type === 'businessLicenseImage') {
          info.socialCode = res.socialCode || '';
          info.companyName = res.companyName || '';
          info.businessLicensePeriod = moment(res.businessLicensePeriod) || '';
        } else if (type === 'idCardPortraitImage') {
          info.legalPersonName = res.legalPersonName || '';
          info.legalPersonIdCard = res.legalPersonIdCard || '';
        } else if (type === 'idCardEmblemImage' && res.legalPersonPeriod) {
          info.legalPersonPeriod = res.legalPersonPeriod
            .replace(/\./g, '/')
            .split('-')
            .map(o => moment(o));
        }
        return {
          businessInfo: Object.assign(state.businessInfo, info),
        };
      });
      this.props.form.setFieldsValue({
        ...info,
      });
    } else {
      notification.error({ message: data.msg });
    }
    this.setState({
      visibleLoading: false,
    });
  };

  /* eslint-disable no-return-assign */
  saveInputRef = input => (this.input = input);

  // 返回
  onCancel = () => {
    // window.history.back();
    getInfo.call(this);
  };

  // 提交
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields(async (err, values) => {
      const obj = Object.assign({}, values); // , this.state.businessInfo
      if (!err) {
        const imgs = this.state.businessInfo;
        obj.businessLicensePeriod = moment(obj.businessLicensePeriod).format('YYYY-MM-DD');
        if (this.state.checkboxDisabled) {
          obj.legalPersonPeriod = '长期';
        } else {
          obj.legalPersonPeriod = obj.legalPerson
            .map(o => moment(o).format('YYYY/MM/DD'))
            .join('-');
        }
        obj.facilities = {
          customList: this.state.businessInfo.customList,
          selfList: obj.selfList,
        };
        const areaArr = ['provinceId', 'cityId', 'countyId', 'townId'];
        obj.addr.forEach((item, i) => {
          obj[areaArr[i]] = item;
        });
        if (this.state.settlementType === 1) {
          obj.accountOpenPermitImage = imgs.accountOpenPermitImage[0].url;
        }
        if (obj.supplierRateDTOList && obj.supplierRateDTOList.length) {
          obj.supplierRateDTOList.forEach(item => {
            if (item.ratedate && item.ratedate.length) {
              item.startDate = moment(item.ratedate[0]).format('YYYY-MM-DD');
              item.endDate = moment(item.ratedate[1]).format('YYYY-MM-DD');
              delete item.ratedate;
            }
          });
        }
        obj.businessLicenseImage = imgs.businessLicenseImage[0].url;
        obj.idCardEmblemImage = imgs.idCardEmblemImage[0].url;
        obj.idCardPortraitImage = imgs.idCardPortraitImage[0].url;
        obj.primaryImage = imgs.primaryImage[0].url;
        obj.sealImage = imgs.sealImage[0].url;

        obj.differentNameAuthorizationImage =
          imgs.differentNameAuthorizationImage?.length &&
          imgs.differentNameAuthorizationImage[0].url;
        obj.householdRegisterImage =
          imgs.householdRegisterImage?.length && imgs.householdRegisterImage[0].url;
        obj.icbProofImage = imgs.icbProofImage?.length && imgs.icbProofImage[0].url;

        obj.applySource = 1;
        obj.signDateType = 1;
        if (imgs.otherImage && imgs.otherImage.length) {
          obj.otherImage = imgs.otherImage.map(item => item.url);
        } else {
          delete obj.otherImage;
        }
        if (imgs.categoryQualificateImage && imgs.categoryQualificateImage.length) {
          obj.categoryQualificateImage = imgs.categoryQualificateImage[0].url;
        } else {
          delete obj.categoryQualificateImage;
        }
        obj.legalPersonIdCard = obj.legalPersonIdCard?.toLocaleUpperCase() || '';
        obj.bankAccountLicenseNum = obj.bankAccountLicenseNum?.toLocaleUpperCase() || '';
        obj.socialCode = obj.socialCode?.toLocaleUpperCase() || '';
        obj.id = this.state.id;
        obj.headImage = obj.primaryImage;
        // this.setState({
        //   loading: true,
        // });
        console.log('obj :>>提交 ', obj);
        const data = await apiEditStoreInfo(obj);
        console.log(data, '.........');
        if (data.businessCode === '0000') {
          // const msg = this.state.type === infoTypeChecked ? '审核完成' : '保存成功';
          notification.success({ message: `${data.msg}！～` });
        }
        this.setState({
          loading: false,
        });
      } else {
        const message = getErrorMessage(err);
        notification.warning({ message });
      }
    });
  };

  onSetPoint = e => {
    this.setFieldsValue({
      latitude: e.lat,
      longitude: e.lng,
    });
  };

  // 修改公司名称
  setCompanyName = () => {
    const val = this.state.companyNamedis;
    this.setState({
      companyNamedis: !val,
    });
  };

  // 修改银行账号
  setBankAccount = () => {
    const val = this.state.bankAccounts;
    this.setState({
      bankAccounts: !val,
    });
  };

  openMap(e, disabled) {
    if (!disabled) {
      this.setState({
        visibleMap: e,
      });
    }
  }

  // eslint-disable-next-line class-methods-use-this
  disabledDate(current) {
    return current && current < moment(moment().format('YYYY-MM-DD'));
  }

  onChangeBusinessModel = e => {
    this.getCategoryList(e);
  };

  // 获取主营类目
  async getCategoryList(e) {
    const data = await apiCategoryList(e);
    if (!data.data) return;
    this.setState({ categoryList: data.data });
  }

  render() {
    const {
      form: { getFieldDecorator },
    } = this.props;
    const {
      businessInfo,
      type,
      checkboxDisabled,
      mainCategoryId,
      companyNamedis,
      bankAccounts,
    } = this.state;
    return (
      <div className={styles.infoBox}>
        <Form className="login-form" onSubmit={this.handleSubmit} {...formItemLayout}>
          <Card title="店铺基本信息">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="业务模式" labelCol={{ span: 4 }}>
                  {getFieldDecorator('productBusiness', {
                    rules: [{ required: true, message: '请选择业务模式!' }],
                    initialValue: businessInfo.productBusiness,
                  })(
                    <Checkbox.Group
                      options={businessModel}
                      onChange={this.onChangeBusinessModel}
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="商户名称" labelCol={{ span: 4 }}>
                  {getFieldDecorator('name', {
                    rules: [{ required: true, message: '请输入商户名称!' }],
                    initialValue: businessInfo.name,
                  })(<Input maxLength={32} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="店铺区域" labelCol={{ span: 4 }}>
                  {getFieldDecorator('addr', {
                    rules: [{ required: true, type: 'array', message: '请选择店铺区域!' }],
                    initialValue: businessInfo.addr,
                  })(
                    <Cascader
                      options={this.state.areaAddr}
                      loadData={e => loadData.call(this, e)}
                      changeOnSelect
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="经营地址" labelCol={{ span: 4 }}>
                  {getFieldDecorator('detailAddress', {
                    rules: [{ required: true, message: '请输入经营地址!' }],
                    initialValue: businessInfo.detailAddress,
                  })(<Input maxLength={500} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人姓名" labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactName', {
                    rules: [{ required: true, message: '请输入联系人姓名!' }],
                    initialValue: businessInfo.contactName,
                  })(<Input maxLength={8} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人手机号" labelCol={{ span: 5 }}>
                  {getFieldDecorator('contactPhone', {
                    rules: [
                      { required: true, message: '请输入联系人手机号!' },
                      { validator: validatePhone, message: '请输入正确的手机号!' },
                    ],
                    initialValue: businessInfo.contactPhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人邮箱" labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactEmail', {
                    rules: [
                      { required: true, message: '请输入联系人邮箱!' },
                      { validator: validateEMail, message: '请输入正确的邮箱！' },
                    ],
                    initialValue: businessInfo.contactEmail,
                  })(<Input />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="客服电话" labelCol={{ span: 5 }}>
                  {getFieldDecorator('servicePhone', {
                    rules: [{ required: true, message: '请输入客服电话!' }],
                    initialValue: businessInfo.servicePhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="签约日期" labelCol={{ span: 4 }}>
                  {getFieldDecorator('signDateType', {
                    rules: [{ required: true, message: '请选择签约日期' }],
                    initialValue: businessInfo.signDateType,
                  })(<Checkbox>自商品售卖起默认一年</Checkbox>)}
                </FormItem>
              </Col>
            </Row>
          </Card>
          <Card title="店铺营业信息">
            <Col span={12} className={styles.imgList}>
              <FormItem label="商户头图" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                {getFieldDecorator('primaryImage', {
                  rules: [{ required: true, message: '请上传商户头图!' }],
                  initialValue: businessInfo.primaryImage,
                })(
                  <Upload
                    {...uploadPropsFn.call(this, { keyName: 'primaryImage', type: 1 })}
                    fileList={businessInfo.primaryImage}
                  >
                    <UploadOutlined /> 上传文件
                  </Upload>,
                )}
              </FormItem>
            </Col>

            <Col span={24}>
              <FormItem label="服务设施" labelCol={{ span: 4 }}>
                {getFieldDecorator('selfList', {
                  initialValue: businessInfo.selfList,
                })(
                  <Select mode="multiple">
                    {this.state.serviceFacilitys.map(item => (
                      <Option value={item.code} key={item.code}>
                        {item.desc}
                      </Option>
                    ))}
                  </Select>,
                )}
              </FormItem>
            </Col>
            <Col span={24}>
              <FormItem label="自定义服务设施" labelCol={{ span: 4 }}>
                {getFieldDecorator('customList', {
                  initialValue: businessInfo.customList,
                })(renderServiceTags.call(this))}
              </FormItem>
            </Col>
          </Card>
          <Card title="证照信息录入区">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="主营类目" labelCol={{ span: 4 }}>
                  {getFieldDecorator('mainCategoryId', {
                    rules: [{ required: true, message: '请选择主营类目!' }],
                    initialValue: businessInfo.mainCategoryId,
                  })(
                    <Select
                      onChange={e => this.onMainCategory(e)}
                      showSearch
                      filterOption={(input, option) =>
                        option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                      }
                    >
                      {this.state.categoryList.map(item => (
                        <Option value={item.id} key={item.id}>
                          {item.name}
                        </Option>
                      ))}
                    </Select>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="企业类型" labelCol={{ span: 4 }}>
                  {getFieldDecorator('companyType', {
                    rules: [{ required: true, message: '请选择企业类型!' }],
                    initialValue: businessInfo.companyType,
                  })(
                    <Radio.Group disabled={businessInfo.companyType}>
                      <Radio value={1}>一般纳税人</Radio>
                      <Radio value={2}>小规模</Radio>
                      <Radio value={3}>个体工商</Radio>
                    </Radio.Group>,
                  )}
                </FormItem>
              </Col>
              <Col span={24} className={styles.imgList}>
                <FormItem label="营业执照" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('businessLicenseImage', {
                    rules: [{ required: true, message: '请上传营业执照!' }],
                    initialValue: businessInfo.businessLicenseImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'businessLicenseImage', type: 2 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.businessLicenseImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={12}>
                <Row>
                  <Col span={4} style={{ marginTop: '4px' }}>
                    {businessInfo.companyName && (
                      <Button onClick={this.setCompanyName}>修改</Button>
                    )}
                  </Col>
                  <Col span={12}>
                    <FormItem label="公司名称" labelCol={{ span: 8 }}>
                      {getFieldDecorator('companyName', {
                        rules: [{ required: true, message: '请输入公司名称!' }],
                        initialValue: businessInfo.companyName,
                      })(<Input maxLength={50} disabled={companyNamedis} />)}
                    </FormItem>
                  </Col>
                </Row>
              </Col>
              <Col span={12}>
                <FormItem label="统一社会信用代码" labelCol={{ span: 8 }}>
                  {getFieldDecorator('socialCode', {
                    rules: [{ required: true, message: '请输入统一社会信用代码!' }],
                    initialValue: businessInfo.socialCode,
                  })(<Input maxLength={32} />)}
                </FormItem>
              </Col>
              {!companyNamedis && businessInfo.companyType && businessInfo.companyType !== 2 && (
                <Col span={12}>
                  <FormItem label="工商局变更证明" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('icbProofImage', {
                      rules: [{ required: true, message: '请上传工商局变更证明!' }],
                      initialValue: businessInfo.icbProofImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'icbProofImage',
                          type: 3,
                          maxSize: 1024 * 200,
                          maxSizeMsg: '文件大小不能超过200K',
                          limit: 1,
                        })}
                        fileList={businessInfo.icbProofImage}
                      >
                        <UploadOutlined /> 上传文件
                      </Upload>,
                    )}
                  </FormItem>
                </Col>
              )}
              {!companyNamedis && businessInfo.companyType && businessInfo.companyType === 2 && (
                <Col span={12}>
                  <FormItem label="户口本本人页" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('householdRegisterImage', {
                      rules: [{ required: true, message: '请上传户口本本人页!' }],
                      initialValue: businessInfo.householdRegisterImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'householdRegisterImage',
                          type: 3,
                          maxSize: 1024 * 200,
                          maxSizeMsg: '文件大小不能超过200K',
                          limit: 1,
                        })}
                        fileList={businessInfo.householdRegisterImage}
                      >
                        <UploadOutlined /> 上传文件
                      </Upload>,
                    )}
                  </FormItem>
                </Col>
              )}
              {((businessInfo.differentNameAuthorizationImage &&
                businessInfo.differentNameAuthorizationImage.length) ||
                !companyNamedis) && (
                <Col span={24}>
                  <FormItem
                    label="非同名结算授权文件"
                    labelCol={{ span: 4 }}
                    wrapperCol={wrapperCol}
                  >
                    {getFieldDecorator('differentNameAuthorizationImage', {
                      initialValue: businessInfo.differentNameAuthorizationImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'differentNameAuthorizationImage',
                          type: 3,
                          maxSize: 1024 * 200,
                          maxSizeMsg: '文件大小不能超过200K',
                          limit: 1,
                        })}
                        fileList={businessInfo.differentNameAuthorizationImage}
                      >
                        <UploadOutlined /> 上传文件
                      </Upload>,
                    )}
                  </FormItem>
                </Col>
              )}
              <Col span={24}>
                <FormItem label="营业执照有效期" labelCol={{ span: 4 }}>
                  {getFieldDecorator('businessLicensePeriod', {
                    rules: [{ required: true, message: '请选择营业执照有效期!' }],
                    initialValue: businessInfo.businessLicensePeriod,
                  })(<DatePicker maxLength={50} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="类目所需资质" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('categoryQualificateImage', {
                    initialValue: businessInfo.categoryQualificateImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, {
                        keyName: 'categoryQualificateImage',
                        type: 6,
                      })}
                      fileList={businessInfo.categoryQualificateImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="电子签章" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('sealImage', {
                    rules: [{ required: true, message: '请上传电子签章!' }],
                    initialValue: businessInfo.sealImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, {
                        keyName: 'sealImage',
                        type: 3,
                        maxSize: 1024 * 200,
                        maxSizeMsg: '文件大小不能超过200K',
                        limit: 1,
                      })}
                      fileList={businessInfo.sealImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              {+mainCategoryId === 301008 && (
                <div>
                  <Col span={24}>
                    <FormItem label="授权品牌" labelCol={{ span: 4 }}>
                      {getFieldDecorator('brand', {
                        initialValue: businessInfo.brand,
                      })(<Input maxLength={32} />)}
                    </FormItem>
                  </Col>
                  <Col span={24}>
                    <FormItem
                      label="品牌经销商授权书"
                      labelCol={{ span: 4 }}
                      wrapperCol={wrapperCol}
                    >
                      {getFieldDecorator('brandCertificate', {
                        initialValue: businessInfo.brandCertificate,
                      })(
                        <Upload
                          {...uploadPropsFn.call(this, {
                            keyName: 'brandCertificate',
                            type: 3,
                            limit: 1,
                          })}
                          fileList={businessInfo.brandCertificate}
                        >
                          <UploadOutlined /> 上传文件
                        </Upload>,
                      )}
                    </FormItem>
                  </Col>
                </div>
              )}
            </Row>
          </Card>
          <Card title="法人信息录入区">
            <Row gutter={24}>
              <Col span={12} className={styles.imgList}>
                <FormItem label="法人身份证人像面" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('idCardPortraitImage', {
                    rules: [{ required: true, message: '请上传身份证人像面!' }],
                    initialValue: businessInfo.idCardPortraitImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'idCardPortraitImage', type: 5 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.idCardPortraitImage}
                    >
                      <UploadOutlined />
                      <div>身份证人像面</div>
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={12} className={styles.imgList}>
                <FormItem label="法人身份证国徽面" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('idCardEmblemImage', {
                    rules: [{ required: true, message: '请上传身份证国徽面!' }],
                    initialValue: businessInfo.idCardEmblemImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'idCardEmblemImage', type: 4 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.idCardEmblemImage}
                    >
                      <UploadOutlined />
                      <div>身份证国徽面</div>
                    </Upload>,
                  )}
                </FormItem>
              </Col>

              <Col span={12}>
                <FormItem label="证件姓名" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonName', {
                    rules: [{ required: true, message: '请输入证件姓名!' }],
                    initialValue: businessInfo.legalPersonName,
                  })(<Input maxLength={8} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="身份证号码" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonIdCard', {
                    rules: [{ required: true, message: '请输入身份证号码!' }],
                    initialValue: businessInfo.legalPersonIdCard,
                  })(<Input maxLength={18} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <Row gutter={24}>
                  <Col span={18}>
                    <FormItem label="身份证有效期" labelCol={{ span: 8 }}>
                      {getFieldDecorator('legalPerson', {
                        rules: [{ required: !checkboxDisabled, message: '请输入身份证有效期!' }],
                        initialValue: businessInfo.legalPerson,
                      })(<RangePicker disabled={checkboxDisabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={6}>
                    <FormItem labelCol={{ span: 8 }}>
                      {getFieldDecorator('legalPersonPeriod', {
                        initialValue: businessInfo.checked,
                      })(
                        <Checkbox Group className={styles.radio} onChange={this.oncheckedChange}>
                          长期
                        </Checkbox>,
                      )}
                    </FormItem>
                  </Col>
                </Row>
              </Col>

              <Col span={12}>
                <FormItem label="手机号" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonPhone', {
                    rules: [
                      { required: true, message: '请输入手机号!' },
                      { validator: validatePhone, message: '请输入正确的手机号!' },
                    ],
                    initialValue: businessInfo.legalPersonPhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="其它证照" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('otherImage', {
                    initialValue: businessInfo.otherImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, { keyName: 'otherImage', limit: 9, type: 7 })}
                      fileList={businessInfo.otherImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
            </Row>
          </Card>
          <Card title="结算信息录入区">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="账户类型" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('settlementType', {
                    rules: [{ required: true, message: '请选择账户类型!' }],
                    initialValue: businessInfo.settlementType,
                  })(
                    <Radio.Group onChange={e => this.onChangeSettlType(e)}>
                      <Radio value={1}>对公</Radio>
                      <Radio value={2}>对私(小微商户)</Radio>
                    </Radio.Group>,
                  )}
                </FormItem>
              </Col>
            </Row>
            {this.state.settlementType === 1 && (
              <Row gutter={24}>
                <Col span={12}>
                  <FormItem label="开户许可证" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('accountOpenPermitImage', {
                      rules: [{ required: true, message: '请上传开户许可证!' }],
                      initialValue: businessInfo.accountOpenPermitImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'accountOpenPermitImage',
                          type: 8,
                        })}
                        fileList={businessInfo.accountOpenPermitImage}
                      >
                        <UploadOutlined /> 上传文件
                      </Upload>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户许可证编号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountLicenseNum', {
                      rules: [{ required: true, message: '请输入开户许可证编号!' }],
                      initialValue: businessInfo.bankAccountLicenseNum,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户名称" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountName', {
                      rules: [{ required: true, message: '请输入开户名称!' }],
                      initialValue: businessInfo.bankAccountName,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户行" labelCol={{ span: 8 }}>
                    {getFieldDecorator('accountBankName', {
                      rules: [{ required: true, message: '请选择开户行!' }],
                      initialValue: businessInfo.accountBankName,
                    })(
                      <Select
                        showSearch
                        filterOption={(input, option) =>
                          (option?.value ?? '').toLowerCase().includes(input.toLowerCase())
                        }
                      >
                        {this.state.bankList.map(item => (
                          <Option value={item.bankName} key={item.bankName}>
                            {item.bankName}
                          </Option>
                        ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <Row>
                    <Col span={4} style={{ marginTop: '4px' }}>
                      {businessInfo.companyName && (
                        <Button onClick={this.setBankAccount}>修改</Button>
                      )}
                    </Col>
                    <FormItem label="银行帐号" labelCol={{ span: 8 }}>
                      {getFieldDecorator('bankAccount', {
                        rules: [{ required: true, message: '请输入银行帐号!' }],
                        initialValue: businessInfo.bankAccount,
                      })(<Input maxLength={20} disabled={!bankAccounts} />)}
                    </FormItem>
                  </Row>
                </Col>
                <Col span={12}>
                  <FormItem label="联行号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('interbankNum', {
                      initialValue: businessInfo.interbankNum,
                    })(<Input maxLength={50} />)}
                  </FormItem>
                </Col>
                {((businessInfo.differentNameAuthorizationImage &&
                  businessInfo.differentNameAuthorizationImage.length) ||
                  bankAccounts) && (
                  <Col span={24}>
                    <FormItem
                      label="非同名结算授权文件"
                      labelCol={{ span: 4 }}
                      wrapperCol={wrapperCol}
                    >
                      {getFieldDecorator('differentNameAuthorizationImage', {
                        initialValue: businessInfo.differentNameAuthorizationImage,
                      })(
                        <Upload
                          {...uploadPropsFn.call(this, {
                            keyName: 'differentNameAuthorizationImage',
                            type: 3,
                            maxSize: 1024 * 200,
                            maxSizeMsg: '文件大小不能超过200K',
                            limit: 1,
                          })}
                          fileList={businessInfo.differentNameAuthorizationImage}
                        >
                          <UploadOutlined /> 上传文件
                        </Upload>,
                      )}
                    </FormItem>
                  </Col>
                )}
              </Row>
            )}
            {this.state.settlementType === 2 && (
              <Row gutter={24}>
                <Col span={12}>
                  <FormItem label="银行卡类型" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountType', {
                      rules: [{ required: true, message: '请选择银行卡类型!' }],
                      initialValue: businessInfo.bankAccountType,
                    })(
                      <Select>
                        <Option value={1} key={1}>
                          借记卡
                        </Option>
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户名称" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountName', {
                      rules: [{ required: true, message: '请输入开户名称!' }],
                      initialValue: businessInfo.bankAccountName,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户行" labelCol={{ span: 8 }}>
                    {getFieldDecorator('accountBankName', {
                      rules: [{ required: true, message: '请选择开户行!' }],
                      initialValue: businessInfo.accountBankName,
                    })(
                      <Select
                        showSearch
                        filterOption={(input, option) =>
                          (option?.value ?? '').toLowerCase().includes(input.toLowerCase())
                        }
                      >
                        {this.state.bankList.map(item => (
                          <Option value={item.bankName} key={item.bankName}>
                            {item.bankName}
                          </Option>
                        ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="银行帐号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccount', {
                      rules: [{ required: true, message: '请输入银行帐号!' }],
                      initialValue: businessInfo.bankAccount,
                    })(<Input maxLength={20} />)}
                  </FormItem>
                </Col>
              </Row>
            )}
          </Card>
          {/* 汽车301008   */}
          {+mainCategoryId === 301008 && (
            <Card title="其他信息">
              <Row gutter={24}>
                <Col span={24}>
                  <FormItem label="礼包内容" labelCol={{ span: 4 }}>
                    {getFieldDecorator('giftPackageContent', {
                      rules: [{ required: true, message: '请输入礼包内容!' }],
                      initialValue: businessInfo.giftPackageContent,
                    })(<Input style={{ width: '50%' }} />)}
                  </FormItem>
                </Col>
                <Col span={24}>
                  <FormItem label="邀请码" labelCol={{ span: 4 }}>
                    {getFieldDecorator('invitationCode', {
                      rules: [{ required: true, message: '请输入邀请码!' }],
                      initialValue: businessInfo.invitationCode,
                    })(<Input style={{ width: '50%' }} />)}
                  </FormItem>
                </Col>
              </Row>
            </Card>
          )}

          <div className={styles.formBtns}>
            <Row gutter={24}>
              <Col span={8}>
                <Button type="primary" size="large" htmlType="submit" loading={this.state.loading}>
                  修改并提交
                </Button>
              </Col>
              <Col span={12}>
                <Button size="large" onClick={this.onCancel}>
                  取消
                </Button>
              </Col>
            </Row>
          </div>
        </Form>
        <MapModal
          visible={this.state.visibleMap}
          onCancel={() => this.openMap(false)}
          onSetPoint={e => this.onSetPoint(e)}
        ></MapModal>
        {this.state.visibleLoading && (
          <div className={styles.spinBox}>
            <div className={styles.spinBoxWrapper}>
              <Spin tip="Loading..." />
            </div>
          </div>
        )}
      </div>
    );
  }
}
export default Form.create()(BusinessInfo);
