import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { notification, Button, Modal, Image } from 'antd';
import { query } from './services';

const ContractView = () => {
  const [visible, setVisible] = useState(false);
  const url =
    'https://contract-test.q-gp.com/621-621T18364B279E2null.pdf?Expires=1679994655&OSSAccessKeyId=LTAI5tGV1jdSEBjuKDUYZVHY&Signature=nVC2YgG8t5DWZl6sMyRmCzeRYLw%3D';
  // 查看
  const onLook = ({ contractPdfUrl }) => {
    setVisible(true);
    // window.open(url)
  };
  // 下载
  const ondown = ({ contractPdfUrl }) => {
    window.open(url);
  };
  const columns = [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
      align: 'center',
    },
    {
      title: '签约时间',
      dataIndex: 'signDate',
      key: 'signDate',
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '合同状态',
      dataIndex: 'state',
      key: 'state',
      align: 'center',
      filters: false,
      valueEnum: {
        0: '失效',
        1: '有效',
      },
    },
    {
      title: '操作',
      dataIndex: 'action',
      width: 200,
      align: 'center',
      hideInSearch: true,
      render: (text, record) => (
        <>
          <Button
            key="edit"
            type="primary"
            onClick={() => onLook(record)}
            style={{ marginRight: '10px' }}
          >
            查看
          </Button>
          <Button key="del" type="primary" onClick={() => ondown(record)}>
            下载
          </Button>
        </>
      ),
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={columns}
        request={params => query({ ...params })}
        rowKey={r => r.appealNo}
        expandIconColumnIndex={10}
        bordered
        toolBarRender={false}
        scroll={{ x: '100%', y: 400 }}
      />
      <Modal visible={visible} width="1000px" onCancel={() => setVisible(false)}>
        <iframe src={url} height="500" width="95%" title="合同"></iframe>
      </Modal>
    </PageHeaderWrapper>
  );
};
export default ContractView;
