import React from 'react';
import { Button } from 'antd';
import styles from '../style.less';

const productType = {
  1: '普通商品',
  2: '虚拟商品',
  3: '电子卡卷',
  4: '服务商品',
  5: '外卖商品',
};

export const columns = ({ onDel, onEdit }) => [
  {
    title: '草稿ID',
    dataIndex: 'id',
    width: 85,
    align: 'center',
  },
  {
    title: '商品名称',
    dataIndex: 'productName',
    align: 'center',
    render(text) {
      return <div className={styles.draftName}>{text}</div>;
    },
  },
  {
    title: '所属类目',
    dataIndex: 'leimu',
    width: 240,
    align: 'center',
    render(text, record) {
      if (record.firstCategoryName) {
        return `${record.firstCategoryName}>${record.secondCategoryName}>${record.thirdCategoryName}`;
      }
      return '-';
    },
  },
  {
    title: '商品类型',
    dataIndex: 'productType',
    width: 100,
    align: 'center',
    render(text) {
      return productType[text];
    },
  },
  {
    title: '创建时间',
    dataIndex: 'createdAt',
    width: 120,
    align: 'center',
  },
  {
    title: '操作',
    dataIndex: 'action',
    width: 130,
    align: 'center',
    render: (text, record) => (
      <>
        <Button key="edit" type="link" size="small" onClick={() => onEdit(record)}>
          修改
        </Button>
        <Button key="viewP" type="link" size="small" onClick={() => onDel(record)}>
          删除
        </Button>
      </>
    ),
  },
];
