import React from 'react';
import { Button, Dropdown, Menu } from 'antd';
import { PlusOutlined, DownOutlined } from '@ant-design/icons';
import { batchAction } from '../../staticdata';
import styles from '../../style.less';

const ActionBar = options => {
  const menus = (
    <Menu>
      {batchAction.map(item => (
        <Menu.Item>{item.label}</Menu.Item>
      ))}
    </Menu>
  );

  return (
    <div className={styles['action-bar-box']}>
      <Button type="primary" icon={<PlusOutlined />}>
        该分组下新增商品
      </Button>
      <Dropdown overlay={menus} className={styles['action-bar-box--down']} placement="bottomLeft">
        <Button type="primary">
          批量操作 <DownOutlined />
        </Button>
      </Dropdown>
    </div>
  );
};

export default ActionBar;
