import React, { useState, forwardRef, useImperativeHandle, useEffect } from 'react';
import { Modal, Timeline, notification, Spin } from 'antd';
import { getLogisticsRecord } from '../services';

const LogisticsRecordModal = (props, ref) => {
  // const { } = props;

  const [visible, setVisible] = useState(false);
  const [result, setResult] = useState({});
  const [loading, setLoading] = useState(false);

  const getRecordList = async orderNo => {
    const tempObj = {
      detailList: [],
      key: Date.now(),
    };
    setLoading(true);
    const res = await getLogisticsRecord({ orderNo });
    setLoading(false);
    if (!res) {
      notification.info({ message: '暂无物流信息' });
      return;
    }
    const { logisticsName, logisticsBillNo, logisticsList = [] } = res.data;
    tempObj.expressCompanyName = logisticsName;
    tempObj.deliveryNo = logisticsBillNo;
    logisticsList.forEach(v => {
      tempObj.detailList = [...tempObj.detailList, ...v.detailList];
    });
    setResult(tempObj);
  };

  const open = orderNo => {
    setVisible(true);
    getRecordList(orderNo);
  };
  const onCancel = () => {
    setVisible(false);
    setResult([]);
  };
  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: '查看物流',
    visible,
    onCancel,
    destroyOnClose: true,
    bodyStyle: { maxHeight: '600px', minHeight: '200px', overflow: 'auto' },
    footer: null,
  };
  const emptyStyle = {
    textAlign: 'center',
    padding: '30px 0',
    color: '#999',
  };

  return (
    <Modal {...modalProps}>
      <Spin spinning={loading}>
        {result.detailList?.length ? (
          <Timeline>
            {result?.detailList?.map((item, index) => (
              <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index.toString()}>
                <p>{item.desc}</p>
                <p>{item.logisticsTime}</p>
              </Timeline.Item>
            ))}
          </Timeline>
        ) : (
          <div style={emptyStyle}>暂无物流信息</div>
        )}
      </Spin>
    </Modal>
  );
};

export default forwardRef(LogisticsRecordModal);
