import request from '@/utils/request';
import config from '../../../config/env.config';

let { kdspApi } = config;
kdspApi = 'http://yapi.quantgroups.com/mock/351';

// 分页查询所有数据
export async function searchList(params, queryStatus) {
  const param = {
    ...params,
    pageNo: params.current,
    queryStatus,
  };
  const data = await request.post('/api/kdsp/op/afs/shop/list', {
    data: param,
    prefix: kdspApi,
  });
  if (data.data) {
    return {
      total: data.data.total,
      data: data.data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

// 售后单详情
export async function jdInfo(params) {
  const data = await request.get('/api/kdsp/op/afs/jd-info', {
    params,
    prefix: kdspApi,
  });
  return data.data || {};
}
// 售后审核
export async function shopAudit(params) {
  return request.post('/api/kdsp/op/afs/shop/audit', {
    params,
    prefix: kdspApi,
  });
}
// 查询审核信息
export async function auditInfoApi(serviceNo) {
  return request.get('/api/kdsp/op/afs/back-info', {
    params: { serviceNo },
    prefix: kdspApi,
  });
}

// 审核核检
export async function shopCheck(params) {
  return request.post('/api/kdsp/op/afs/shop/check', {
    params,
    prefix: kdspApi,
  });
}
// 查询物流信息
export async function trackInfo(params) {
  const data = await request.get('/api/kdsp/logistics/kd100/track-list', {
    params,
    prefix: kdspApi,
  });
  if (data.businessCode === '0000') {
    return data.data;
  }
  return {};
}
