import React, { useState } from 'react';
import { Modal, Form, Radio, Input, Button, Upload, message, Select } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import { apiDepartmentSave, apiDepartmentExcel, apiStaffExcel } from '../service';
import styles from '../index.less';

const { Dragger } = Upload;
const { Item } = Form;
const layout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 16 },
};
const DepartmentModal = ({ visible, onClose, enterpriseList }) => {
  const [form] = Form.useForm();

  const handleCancel = val => {
    form.resetFields();
    onClose(val);
  };

  const handleImportChange = info => {
    if (info.file.status === 'done') {
      message.success('文件上传成功');
    } else if (info.file.status === 'error') {
      message.error('文件上传失败');
    }
  };

  const handleSave = () => {
    form.validateFields().then(async values => {
      const params = {
        enterpriseId: values.enterpriseId,
        file: values.file,
      };
      const res = await apiStaffExcel(params);
      if (res.businessCode === '0000') {
        message.success('上传成功');
        handleCancel(true);
      }
    });
  };

  return (
    <Modal
      title="创建部门"
      visible={visible}
      onCancel={() => handleCancel(false)}
      footer={[
        <Button key="cancel" onClick={onClose}>
          取消
        </Button>,
        <Button key="save" type="primary" onClick={() => handleSave()}>
          保存
        </Button>,
      ]}
      initialValue={{ configMode: 0 }}
    >
      <Form form={form} {...layout}>
        <Item
          label="选择企业"
          name="enterpriseId"
          rules={[{ required: true, message: '请选择企业' }]}
        >
          <Select
            placeholder="请选择企业"
            allowClear
            showSearch
            filterOption={(input, option) =>
              (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
            }
            options={enterpriseList}
          />
        </Item>
        <Item
          label="上传文件"
          name="file"
          rules={[
            { required: true, message: '请上传文件' },
            {
              // eslint-disable-next-line no-confusing-arrow
              validator: (_, value) =>
                value && value.fileList.length > 0
                  ? Promise.resolve()
                  : // eslint-disable-next-line prefer-promise-reject-errors
                    Promise.reject('请上传文件'),
            },
          ]}
        >
          <Dragger
            beforeUpload={() => false}
            onChange={handleImportChange}
            maxCount={1}
            accept=".xls,.xlsx"
          >
            <UploadOutlined />
            <p>
              将文件拖到此处，或<a href="#">点击上传</a>
            </p>
          </Dragger>
        </Item>
      </Form>
      <div className={styles.employees}>
        <a
          data-v-7e627236=""
          href="https://img.mumcooking.com//personnel/excel.xlsx?v1"
          className="batchDialog-row-download-a"
        >
          员工导入模版.xlsx
        </a>
      </div>
    </Modal>
  );
};

export default DepartmentModal;
