import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal, Select, Form, notification } from 'antd';
import styles from '../index.less';

const AddModal = props => {
  const { addVisible } = props;
  const [shopIds, setShopIds] = useState([]);
  const handleCancel = () => {
    props.onCancel(false);
  };
  const handleChange = value => {
    setShopIds(value);
  };
  const onOk = () => {
    if (!shopIds.length) {
      notification.error({
        message: '请添加微店',
      });
    }
  };
  return (
    <>
      <Modal title="添加企业店铺" onOk={onOk} visible={addVisible} onCancel={() => handleCancel()}>
        <Form>
          <Form.Item label="企业名称">
            <span>企业名称</span>
          </Form.Item>
          <Form.Item label="添加微店" name="shopIds">
            <Select
              mode="multiple"
              allowClear
              style={{ width: '100%' }}
              placeholder="请选择微店"
              onChange={handleChange}
              // options={options}
            />
          </Form.Item>
          <Form.Item label="餐饮类型">
            <span>餐饮类型</span>
          </Form.Item>
        </Form>
      </Modal>
    </>
  );
};

export default AddModal;
