import React, { useState } from 'react';
import { Modal, Form, Input, Button, Select, message } from 'antd';
import { apiStaffSave } from '../service';

const { Option } = Select;

const layout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 16 },
};
const NewEmployeeModal = props => {
  const { departmentList, visible, onClose, enterpriseList, getDepartmentList } = props;
  const [form] = Form.useForm();
  const [loading, setLoading] = useState(false);

  const handleSave = () => {
    form.validateFields().then(async values => {
      setLoading(true);
      const res = await apiStaffSave(values);
      if (res.businessCode === '0000') {
        setLoading(false);
        message.success('保存成功');
        onClose(true);
      }
    });
  };

  const validatePhone = (_, value) => {
    const phoneRegex = /^[1-9]\d{9}$/;
    if (!value || phoneRegex.test(value)) {
      return Promise.resolve();
    }
    // eslint-disable-next-line prefer-promise-reject-errors
    return Promise.reject('请输入有效的手机号码');
  };

  const onChange = value => {
    getDepartmentList(value);
  };
  return (
    <Modal
      visible={visible}
      title="添加新员工"
      onCancel={onClose}
      footer={[
        <Button key="cancel" onClick={onClose}>
          取消
        </Button>,
        <Button key="save" type="primary" loading={loading} onClick={handleSave}>
          保存
        </Button>,
      ]}
    >
      <Form form={form} {...layout}>
        <Form.Item
          name="enterpriseId"
          label="企业"
          rules={[
            {
              required: true,
              message: '请选择企业',
            },
          ]}
        >
          <Select
            onChange={onChange}
            placeholder="请选择企业"
            allowClear
            showSearch
            filterOption={(input, option) =>
              (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
            }
            options={enterpriseList}
          />
        </Form.Item>
        <Form.Item
          name="departmentId"
          label="部门"
          rules={[
            {
              required: true,
              message: '请选择部门',
            },
          ]}
        >
          <Select
            placeholder="请选择部门"
            allowClear
            showSearch
            filterOption={(input, option) =>
              (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
            }
            options={departmentList}
          />
        </Form.Item>
        <Form.Item
          name="staffNo"
          label="员工ID"
          rules={[
            {
              required: true,
              message: '请输入员工ID',
            },
          ]}
        >
          <Input />
        </Form.Item>
        <Form.Item
          name="staffName"
          label="员工姓名"
          rules={[
            {
              required: true,
              message: '请输入员工姓名',
            },
          ]}
        >
          <Input />
        </Form.Item>
        <Form.Item
          name="mobile"
          label="员工手机号"
          rules={[
            {
              required: true,
              message: '请输入员工手机号',
            },
            {
              validator: validatePhone,
            },
          ]}
        >
          <Input />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default NewEmployeeModal;
