import React from 'react';
import moment from 'moment';
import MealSection from './components/MealSection';
import MealFormListLimit from './components/MealFormListLimitForm';
import { getPickSelf } from './bll';

const hideEnums = { hidePrice: '隐藏商品价格', hideImage: '隐藏商品图片' };
const weekMap = new Map([[1, '是'], [0, '否']]);

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};

// 餐品类型
export const mealType = {
  1: '外卖',
  2: '自助餐',
  4: '到店',
};
// 餐段
export const mealSections = {
  1: '早餐',
  2: '午餐',
  4: '晚餐',
};

// 校验时间
const checkTime = (arr, current) => {
  let valid = false;
  arr.forEach(item => {
    if (current < item.endTime) {
      valid = true;
    }
  });
  return valid;
};
// 验证餐段
const validateMeals = (refForm, selectedMealSections) => {
  const { mealTimePeriod = [] } = refForm.current?.getFieldValue?.() || {};
  const arr = [];
  let validTime = false;
  mealTimePeriod.forEach(item => {
    if (item && selectedMealSections[item.mealPeriodType]) {
      const obj = { ...item };
      if (obj.time?.length === 2) {
        obj.beginTime = moment(obj.time[0]).format('HH:mm');
        obj.endTime = moment(obj.time[1]).format('HH:mm');
        if (checkTime(arr, obj.beginTime, selectedMealSections[item.mealPeriodType])) {
          validTime = true;
        }
        arr.push(obj);
      }
    }
  });
  if (validTime) {
    // eslint-disable-next-line prefer-promise-reject-errors
    return Promise.reject('时间段不能交叉！');
  }
  return Promise.resolve();
};

// 获取 schemaForm 的 columns
export const getBaseFormItem = options => {
  const {
    id,
    selectedMealTypes,
    onChangeMealType,
    selectedMealSections,
    onChangeMealSection,
    refForm,
  } = options;

  const baseColumn = [
    {
      title: '企业名称',
      dataIndex: 'name',
      formItemProps: {
        rules: [{ required: true, message: '请输入企业名称' }],
      },
    },
    {
      hideInForm: !!id,
      title: '企业取餐点',
      dataIndex: 'pickSelfIds',
      valueType: 'select',
      fieldProps: {
        mode: 'multiple',
      },
      request: getPickSelf,
      formItemProps: {
        rules: [{ required: true, message: '请选择企业取餐点' }],
      },
    },
    {
      title: '企业截止时间',
      dataIndex: 'endOrderTime',
      valueType: 'digit',
      formItemProps: {
        rules: [{ required: true, message: '请输入企业截止时间' }],
        addonAfter: '分钟',
        extra: <span>企业员工下单的截至时间，仅支持正整数，单位为分钟。</span>,
      },
    },
    {
      title: '餐品类型',
      dataIndex: 'mealType',
      valueType: 'checkbox',
      valueEnum: mealType,
      formItemProps: {
        rules: [{ required: true, message: '请选择餐品类型' }],
      },
      fieldProps: {
        onChange: onChangeMealType,
        name: 'mealType',
      },
    },
    {
      title: '餐段配置',
      dataIndex: 'mealTimePeriod',
      formItemProps: {
        rules: [{ required: true, message: '请选择餐段配置' }],
      },
      fieldProps: {
        copyIconProps: false, // 隐藏复制行按钮
        deleteIconProps: false, // 隐藏删除行按钮
        creatorButtonProps: false, // 隐藏添加行按钮
      },
      renderFormItem: () => (
        <MealSection
          meals={selectedMealSections}
          validateMeals={() => validateMeals(refForm, selectedMealSections)}
          onChangeSection={onChangeMealSection}
        />
      ),
    },
    {
      title: '',
      dataIndex: '',
      valueType: 'divider',
      formItemProps: {
        wrapperCol: { span: 22 },
      },
      fieldProps: {
        children: '企业单笔消费限额',
        orientation: 'left',
      },
    },
    {
      title: '',
      dataIndex: 'mealLimit',
      formItemProps: {
        labelCol: { span: 0 },
        wrapperCol: { span: 24 },
      },
      renderFormItem: () => MealFormListLimit(selectedMealSections, selectedMealTypes),
    },
    {
      title: '商品隐藏信息',
      dataIndex: 'hideInfo',
      valueType: 'checkbox',
      valueEnum: hideEnums,
    },
    {
      title: '是否周预览',
      dataIndex: 'weekPreview',
      formItemProps: {
        rules: [{ required: true, message: '请选择是否周预览' }],
      },
      valueType: 'radio',
      valueEnum: weekMap,
      // convertValue: v => `${v}`, // 从接口获取的数据做简单转换
    },
  ];
  return baseColumn;
};
