import React from 'react';
import { Divider } from 'antd';

export const getColumns = props => {
  const {
    toUserInfo,
    openRolePermissionsModal,
    openUpdateStatusModal,
    openResetPasswordModal,
  } = props;
  return [
    {
      title: '用户ID',
      dataIndex: 'id',
    },
    {
      title: '用户名',
      dataIndex: 'account',
    },
    {
      title: '姓名',
      dataIndex: 'name',
    },
    {
      title: '创建时间',
      dataIndex: 'createTime',
      hideInSearch: true,
    },
    {
      title: '最后一次登录时间',
      dataIndex: 'updateTime',
      hideInSearch: true,
    },
    {
      title: '角色',
      dataIndex: 'creator',
      render: (value, record) => <a onClick={() => openRolePermissionsModal(record)}>{value}</a>,
    },
    {
      title: '状态',
      dataIndex: 'status',
      width: 150,
      initialValue: '3',
      valueEnum: {
        all: { text: '全部', status: '' },
        close: { text: '使用中', status: 2 },
        running: { text: '已禁用', status: 3 },
      },
      render: value => value.name,
    },
    {
      title: '操作',
      key: 'action',
      width: 220,
      hideInSearch: true,
      render: (value, record) => (
        <>
          <a
            onClick={() => {
              toUserInfo(record);
            }}
          >
            编辑
          </a>
          <Divider type="vertical" />
          <a
            onClick={() => {
              openUpdateStatusModal(record);
            }}
          >
            修改状态
          </a>
          <Divider type="vertical" />
          <a
            onClick={() => {
              openResetPasswordModal(record);
            }}
          >
            重置密码
          </a>
        </>
      ),
    },
  ];
};
