import React, { useRef, useState } from 'react';
import { useHistory } from 'react-router-dom';
import { Button, Divider } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { connect } from 'umi';

// data
import { getColumns } from './data';
// compoents
import RolePermissionsModal from './components/RolePermissionsModal';
import UpdateStatusModal from './components/UpdateStatusModal';
import ResetPasswordModal from './components/ResetPasswordModal';

// mock
import { getUserList } from '../service';
import { accountList } from '../mock/account';

const Account = props => {
  const { permissions } = props;
  const history = useHistory();
  const actionRef = useRef();
  const formRef = useRef();

  const rolePermissionsModalRef = useRef();
  const updateStatusModalRef = useRef();
  const resetPasswordModal = useRef();

  // 新增编辑
  const toUserInfo = ({ id } = {}) => {
    const query = id ? { id } : {};
    history.push({
      pathname: '/systemManage/account/userInfo',
      query,
    });
  };

  // 角色权限 modal
  const openRolePermissionsModal = record => {
    rolePermissionsModalRef.current.open(record);
  };

  // 修改状态 modal
  const openUpdateStatusModal = record => {
    updateStatusModalRef.current.open(record);
  };

  // 重置密码 modal
  const openResetPasswordModal = record => {
    resetPasswordModal.current.open(record);
  };

  const reload = () => {
    actionRef.current.reload();
  };

  // 获取列表配置
  const columns = getColumns({
    toUserInfo,
    openRolePermissionsModal,
    openUpdateStatusModal,
    openResetPasswordModal,
  });

  // 表格属性
  const tableProps = {
    columns,
    rowKey: 'id',
    request: async params => {
      console.log('搜索', params);
      const { current: page, pageSize: size } = params;
      const res = await getUserList({
        page,
        size,
      });
      const { content = [], totalElements } = res.data;
      return {
        data: content,
        success: true,
        total: totalElements,
      };
    },
    toolBarRender: () => {
      // TODO: 权限控制
      if (permissions['010102']) {
        return [
          <Button type="primary" onClick={() => toUserInfo()}>
            新增用户
          </Button>,
        ];
      }
      return [];
    },
  };

  // 搜索属性
  const searchProps = {
    collapsed: false,
    collapseRender: () => null,
  };

  return (
    <PageHeaderWrapper>
      <ProTable
        actionRef={actionRef}
        formRef={formRef}
        {...tableProps}
        search={searchProps}
      ></ProTable>

      <RolePermissionsModal ref={rolePermissionsModalRef} />
      <UpdateStatusModal reload={reload} ref={updateStatusModalRef} />
      <ResetPasswordModal reload={reload} ref={resetPasswordModal} />
    </PageHeaderWrapper>
  );
};

// export default Account;

export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(Account);
