import React from 'react';
import { Table } from 'antd';
import style from './style.less';

const GoodsRemark = props => {
  const columns = [
    {
      title: '商品',
      dataIndex: 'skuName',
      width: 350,
      render: (value, record) => {
        const { skuName, imageUrl } = record;
        return (
          <div className={style.popoverGoods}>
            <img src={imageUrl} alt="" className={style['popoverGoods-img']} />
            <span>{skuName}</span>
          </div>
        );
      },
    },
    {
      title: '备注',
      dataIndex: 'content',
      width: 150,
    },
    {
      title: '操作时间',
      dataIndex: 'time',
      width: 150,
    },
  ];

  return (
    <div>
      <Table columns={columns} dataSource={props.dataSource} pagination={false} />
    </div>
  );
};

export default GoodsRemark;
