import request from '@/utils/request';
import config from '@/../config/env.config';
import qs from 'qs';

const { goodsApi } = config;

// 商品导入接口
export async function apiImportGoods(file, type) {
  const params = new FormData();
  params.append('file', file);
  params.append('type', type);
  const res = await request.post('/api/merchants/importFile/excel', {
    data: params,
    prefix: goodsApi,
  });
  return res;
}

// 分页查询上传文件结果
export async function apiUploadResult(params) {
  const data = await request.get(
    `/api/merchants/importFile/info/page${qs.stringify(params, { addQueryPrefix: true })}`,
    {
      prefix: goodsApi,
    },
  );
  return data;
}
