import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal, Radio, Form, Space, message, Checkbox, Col, Row } from 'antd';
import styles from '../index.less';
import { apiShopUpdate } from '../service.js';

const EditRepastModal = props => {
  const [form] = Form.useForm();
  const { editVisible, repastType, id } = props;
  const handleCancel = () => {
    props.onCancel();
  };
  const onOk = () => {
    form.validateFields().then(async values => {
      const params = {
        id,
        mealTypeList: values.mealTypeList,
      };
      const res = await apiShopUpdate(params);
      if (res.businessCode === '0000') {
        message.success('修改成功');
        handleCancel(true);
      }
    });
  };
  return (
    <>
      <Modal title="餐饮类型" onOk={onOk} visible={editVisible} onCancel={() => handleCancel()}>
        <Form layout="vertical" autoComplete="off" form={form}>
          <Form.Item
            label="取餐点下商户餐品类型"
            rules={[{ required: true, message: '请选择商户餐品类型' }]}
          >
            <Checkbox.Group>
              <Space direction="mealTypeList">
                {(repastType.length &&
                  repastType.map((index, value) => <Checkbox>{index}</Checkbox>)) ||
                  ''}
              </Space>
            </Checkbox.Group>
            <p className={styles.tip}>切换餐品类型后，请及时维护商品</p>
          </Form.Item>
          <Form.Item label="是否开启餐品类型">
            <Checkbox.Group>
              <Space direction="vertical">
                <Checkbox>到店</Checkbox>
              </Space>
            </Checkbox.Group>
            <p className={styles.tip}>关闭【到店】餐类时，关联到店企业商品将一并删除</p>
          </Form.Item>
        </Form>
      </Modal>
    </>
  );
};

export default EditRepastModal;
