import React, { Component } from 'react';
import { history } from 'umi';
import moment from 'moment';
import { ArrowRightOutlined, UploadOutlined } from '@ant-design/icons';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import {
  Select,
  Input,
  Radio,
  Checkbox,
  DatePicker,
  Upload,
  Button,
  Card,
  Row,
  Col,
  Cascader,
  notification,
  Spin,
  Tabs,
} from 'antd';
import styles from './style.less';
import {
  wrapperCol,
  uploadPropsFn,
  formItemLayout,
  getCategoryList,
  renderServiceTags,
  loadData,
  getAreaAddr,
  getServiceFacility,
  businessModel,
  getInfo,
  getBankList,
  businessTypeDesc,
} from './data';
import { validatePhone, validateEMail, validNumber } from '@/utils/validator';
import { getErrorMessage } from '@/utils/utils';
import MapModal from '@/components/BaiduMap';
import { apiNewStoreInfo, apiEditStoreInfo, apiRecognize, apiRevision } from '../service';
import {
  infoTypeFind,
  infoTypeChecked,
  infoTypeEdit,
  infoTypeRevision,
  infoTypeInfo,
} from '../staticdata';

const { Option } = Select;
const { Item: FormItem } = Form;
const { RangePicker } = DatePicker;
const { TabPane } = Tabs;

const applyTypeDesc = {
  1: '用户提交申请：',
  3: '易宝驳回：',
};

class BusinessInfo extends Component {
  getFieldDecorator = this.props?.form?.getFieldDecorator;

  setFieldsValue = this.props?.form?.setFieldsValue;

  state = {
    id: null,
    type: infoTypeFind,
    businessInfo: {
      customList: [],
      settlementType: 1,
      companyType: '',
    },
    areaAddr: [], // 四级地址列表
    categoryList: [], // 主要类目
    serviceFacilitys: [], // 服务设施
    bankList: [], // 开户行
    // eslint-disable-next-line react/no-unused-state
    tagVisible: false,
    // eslint-disable-next-line react/no-unused-state
    tagValue: '',
    settlementType: 1,
    loading: false,
    visibleMap: false,
    visibleLoading: false,
    calculateType: [1, 1],
    defaultType: '1',
    visibleCalculate: false,
  };

  async componentDidMount() {
    const { id, type } = this.props.location.query;
    const info = {};
    let businessType = [];
    if (id) {
      info.id = id;
      info.type = type || infoTypeFind;
      await getInfo.call(this, id, type);
      businessType = this.state.businessInfo.productBusiness.map(item => this.getDataInfo(item));
    }
    // find 查看 checked审核 edit修改 info审核之后查看
    if (id && [infoTypeFind, infoTypeInfo, infoTypeRevision].includes(type)) {
      info.disabled = !0;
    } else if (type === infoTypeRevision) {
      // 订正 除了邮箱其他都禁止修改
      info.disabled = !0;
      info.emailDisabled = false;
    }
    this.setState(state => {
      const businessInfo = Object.assign(
        {
          businessType,
        },
        state.businessInfo,
      );
      return {
        ...info,
        businessInfo,
      };
    });
    getAreaAddr.call(this);
    // getCategoryList.call(this);
    getServiceFacility.call(this);
    getBankList.call(this);
  }

  // 审核的时候 切换业务模式 更改服务费率配置
  onChangeBusinessModel = e => {
    if (this.state.type !== infoTypeChecked) {
      return false;
    }
    const arr = [];
    e.forEach(item => {
      if (item === 1 || item === 3) {
        arr.push(item);
      }
    });
    const businessType = arr.map(item => this.getDataInfo(item));
    this.setState(state => {
      const { businessInfo } = state;
      businessInfo.businessType = businessType;
      return {
        businessInfo,
      };
    });
    return console.log('.');
  };

  // 切换审核结果 - 显示/隐藏费率
  onChangeAuditResult = e => {
    this.setState({
      visibleCalculate: e.target.value,
    });
  };

  onTabChange = e => {
    this.setState({
      defaultType: e,
    });
  };

  // eslint-disable-next-line react/sort-comp
  getDataInfo = type => ({
    key: type,
    name: businessTypeDesc[type],
    chargeMethod: 1,
    calculateType: 1,
  });

  // 计费类型改变
  onChangeCalculateType = (e, i) => {
    this.setState(state => {
      const { calculateType } = state;
      calculateType[i] = +e;
      return {
        calculateType,
      };
    });
  };

  static getDerivedStateFromProps() {
    return null;
  }

  // 帐号类型切换
  onChangeSettlType(e) {
    this.setState({
      settlementType: e.target.value,
    });
  }

  // 处理图片
  dealImgInfo = async (type, url) => {
    const imgType = {
      businessLicenseImage: 2,
      idCardPortraitImage: 5,
      idCardEmblemImage: 4,
    };
    if (!url) {
      return;
    }
    this.setState({
      visibleLoading: true,
    });
    const data = await apiRecognize({
      imageUrl: url,
      imageType: imgType[type],
    });
    if (data.businessCode === '0000') {
      const res = data.data;
      const info = {};
      this.setState(state => {
        if (type === 'businessLicenseImage') {
          info.socialCode = res.socialCode || '';
          info.companyName = res.companyName || '';
          info.businessLicensePeriod = moment(res.businessLicensePeriod) || '';
        } else if (type === 'idCardPortraitImage') {
          info.legalPersonName = res.legalPersonName || '';
          info.legalPersonIdCard = res.legalPersonIdCard || '';
        } else if (type === 'idCardEmblemImage' && res.legalPersonPeriod) {
          info.legalPersonPeriod = res.legalPersonPeriod
            .replace(/\./g, '/')
            .split('-')
            .map(o => moment(o));
        }
        return {
          businessInfo: Object.assign(state.businessInfo, info),
        };
      });
      this.props.form.setFieldsValue({
        ...info,
      });
    } else {
      notification.error({ message: data.msg });
    }
    this.setState({
      visibleLoading: false,
    });
  };

  // 订正 - 修改邮箱
  onRevision = () => {
    const email = this.props.form.getFieldValue('contactEmail');
    const contactPhone = this.props.form.getFieldValue('contactPhone');
    if (email) {
      validateEMail('', email, async e => {
        if (!e) {
          const [res, error] = await apiRevision({
            id: this.state.id,
            contactPhone,
            contactEmail: email,
          });
          console.log('res :>> ', res);
          if (!error) {
            notification.success({ message: '订正完成！～' });
            this.onCancel();
          }
        } else {
          notification.warning({ message: '请输入正确的邮箱地址' });
        }
      });
    } else {
      notification.warning({ message: '请输入邮箱地址' });
    }
  };

  /* eslint-disable no-return-assign */
  saveInputRef = input => (this.input = input);

  // 返回
  onCancel = () => {
    window.history.back();
  };

  // 提交
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields(async (err, values) => {
      const obj = Object.assign({}, values); // , this.state.businessInfo
      if (!err) {
        const imgs = this.state.businessInfo;
        obj.businessLicensePeriod = moment(obj.businessLicensePeriod).format('YYYY-MM-DD');
        obj.legalPersonPeriod = obj.legalPersonPeriod
          .map(o => moment(o).format('YYYY/MM/DD'))
          .join('-');
        obj.facilities = {
          customList: this.state.businessInfo.customList,
          selfList: obj.selfList,
        };
        const areaArr = ['provinceId', 'cityId', 'countyId', 'townId'];
        obj.addr.forEach((item, i) => {
          obj[areaArr[i]] = item;
        });
        if (this.state.settlementType === 1) {
          obj.accountOpenPermitImage = imgs.accountOpenPermitImage[0].url;
        }
        if (obj.supplierRateDTOList && obj.supplierRateDTOList.length) {
          obj.supplierRateDTOList.forEach(item => {
            if (item.ratedate && item.ratedate.length) {
              item.startDate = moment(item.ratedate[0]).format('YYYY-MM-DD');
              item.endDate = moment(item.ratedate[1]).format('YYYY-MM-DD');
              delete item.ratedate;
            }
          });
        }
        obj.businessLicenseImage = imgs.businessLicenseImage[0].url;
        obj.idCardEmblemImage = imgs.idCardEmblemImage[0].url;
        obj.idCardPortraitImage = imgs.idCardPortraitImage[0].url;
        obj.primaryImage = imgs.primaryImage[0].url;
        obj.sealImage = imgs.sealImage[0].url;
        obj.applySource = 1;
        if (imgs.otherImage && imgs.otherImage.length) {
          obj.otherImage = imgs.otherImage.map(item => item.url);
        } else {
          delete obj.otherImage;
        }
        if (imgs.categoryQualificateImage && imgs.categoryQualificateImage.length) {
          obj.categoryQualificateImage = imgs.categoryQualificateImage[0].url;
        } else {
          delete obj.categoryQualificateImage;
        }
        obj.legalPersonIdCard = obj.legalPersonIdCard?.toLocaleUpperCase() || '';
        obj.bankAccountLicenseNum = obj.bankAccountLicenseNum?.toLocaleUpperCase() || '';
        obj.socialCode = obj.socialCode?.toLocaleUpperCase() || '';
        let api = apiNewStoreInfo;
        if (this.state.id) {
          obj.id = this.state.id;
          if (this.state.type === infoTypeEdit) {
            obj.headImage = obj.primaryImage;
            api = apiEditStoreInfo;
          }
        } else {
          obj.completed = !0;
        }
        this.setState({
          loading: true,
        });
        console.log('obj :>>提交 ', obj);
        const data = await api(obj);
        if (data.businessCode === '0000') {
          // const msg = this.state.type === infoTypeChecked ? '审核完成' : '保存成功';
          notification.success({ message: `${data.msg}！～` });
        }
        this.setState({
          loading: false,
        });
      } else {
        const message = getErrorMessage(err);
        notification.warning({ message });
      }
    });
  };

  onSetPoint = e => {
    this.setFieldsValue({
      latitude: e.lat,
      longitude: e.lng,
    });
  };

  openMap(e, disabled) {
    if (!disabled) {
      this.setState({
        visibleMap: e,
      });
    }
  }

  // eslint-disable-next-line class-methods-use-this
  disabledDate(current) {
    return current && current < moment(moment().format('YYYY-MM-DD'));
  }

  render() {
    const {
      form: { getFieldDecorator },
    } = this.props;
    const { businessInfo, type } = this.state;
    return (
      <div className={styles.infoBox}>
        <Form className="login-form" onSubmit={this.handleSubmit} {...formItemLayout}>
          <Card title="基本信息">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="业务模式" labelCol={{ span: 4 }}>
                  {getFieldDecorator('productBusiness', {
                    rules: [{ required: true, message: '请选择业务模式!' }],
                    initialValue: businessInfo.productBusiness,
                  })(
                    <Checkbox.Group
                      options={businessModel}
                      onChange={this.onChangeBusinessModel}
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="商户名称" labelCol={{ span: 4 }}>
                  {getFieldDecorator('name', {
                    rules: [{ required: true, message: '请输入商户名称!' }],
                    initialValue: businessInfo.name,
                  })(<Input maxLength={32} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="店铺区域" labelCol={{ span: 4 }}>
                  {getFieldDecorator('addr', {
                    rules: [{ required: true, type: 'array', message: '请选择店铺区域!' }],
                    initialValue: businessInfo.addr,
                  })(
                    <Cascader
                      options={this.state.areaAddr}
                      loadData={e => loadData.call(this, e)}
                      changeOnSelect
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="经营地址" labelCol={{ span: 4 }}>
                  {getFieldDecorator('detailAddress', {
                    rules: [{ required: true, message: '请输入经营地址!' }],
                    initialValue: businessInfo.detailAddress,
                  })(<Input maxLength={500} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人姓名" labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactName', {
                    rules: [{ required: true, message: '请输入联系人姓名!' }],
                    initialValue: businessInfo.contactName,
                  })(<Input maxLength={8} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人手机号" labelCol={{ span: 5 }}>
                  {getFieldDecorator('contactPhone', {
                    rules: [
                      { required: true, message: '请输入联系人手机号!' },
                      { validator: validatePhone, message: '请输入正确的手机号!' },
                    ],
                    initialValue: businessInfo.contactPhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="联系人邮箱" labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactEmail', {
                    rules: [
                      { required: true, message: '请输入联系人邮箱!' },
                      { validator: validateEMail, message: '请输入正确的邮箱！' },
                    ],
                    initialValue: businessInfo.contactEmail,
                  })(<Input />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="客服电话" labelCol={{ span: 5 }}>
                  {getFieldDecorator('servicePhone', {
                    rules: [{ required: true, message: '请输入客服电话!' }],
                    initialValue: businessInfo.servicePhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>

              <Col span={12} className={styles.imgList}>
                <FormItem label="商户头图" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('primaryImage', {
                    rules: [{ required: true, message: '请上传商户头图!' }],
                    initialValue: businessInfo.primaryImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, { keyName: 'primaryImage', type: 1 })}
                      fileList={businessInfo.primaryImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>

              <Col span={24}>
                <FormItem label="服务设施" labelCol={{ span: 4 }}>
                  {getFieldDecorator('selfList', {
                    initialValue: businessInfo.selfList,
                  })(
                    <Select mode="multiple">
                      {this.state.serviceFacilitys.map(item => (
                        <Option value={item.code} key={item.code}>
                          {item.desc}
                        </Option>
                      ))}
                    </Select>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="自定义服务设施" labelCol={{ span: 4 }}>
                  {getFieldDecorator('customList', {
                    initialValue: businessInfo.customList,
                  })(renderServiceTags.call(this))}
                </FormItem>
              </Col>
            </Row>
          </Card>
          <Card title="证照信息录入区">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="主营类目" labelCol={{ span: 4 }}>
                  {getFieldDecorator('mainCategoryId', {
                    // rules: [{ required: true, message: '请选择主营类目!' }],
                    initialValue: businessInfo.mainCategoryId,
                  })(
                    <Select>
                      {this.state.categoryList.map(item => (
                        <Option value={item.categoryId} key={item.categoryId}>
                          {item.categoryName}
                        </Option>
                      ))}
                    </Select>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="企业类型" labelCol={{ span: 4 }}>
                  {getFieldDecorator('companyType', {
                    rules: [{ required: true, message: '请选择企业类型!' }],
                    initialValue: businessInfo.companyType,
                  })(
                    <Radio.Group>
                      <Radio value={1}>一般纳税人</Radio>
                      <Radio value={2}>小规模</Radio>
                      <Radio value={3}>个体工商</Radio>
                    </Radio.Group>,
                  )}
                </FormItem>
              </Col>
              <Col span={24} className={styles.imgList}>
                <FormItem label="营业执照" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('businessLicenseImage', {
                    rules: [{ required: true, message: '请上传营业执照!' }],
                    initialValue: businessInfo.businessLicenseImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'businessLicenseImage', type: 2 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.businessLicenseImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="公司名称" labelCol={{ span: 8 }}>
                  {getFieldDecorator('companyName', {
                    rules: [{ required: true, message: '请输入公司名称!' }],
                    initialValue: businessInfo.companyName,
                  })(<Input maxLength={50} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="统一社会信用代码" labelCol={{ span: 8 }}>
                  {getFieldDecorator('socialCode', {
                    rules: [{ required: true, message: '请输入统一社会信用代码!' }],
                    initialValue: businessInfo.socialCode,
                  })(<Input maxLength={32} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="营业执照有效期" labelCol={{ span: 4 }}>
                  {getFieldDecorator('businessLicensePeriod', {
                    rules: [{ required: true, message: '请选择营业执照有效期!' }],
                    initialValue: businessInfo.businessLicensePeriod,
                  })(<DatePicker maxLength={50} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="类目所需资质" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('categoryQualificateImage', {
                    initialValue: businessInfo.categoryQualificateImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, {
                        keyName: 'categoryQualificateImage',
                        type: 6,
                      })}
                      fileList={businessInfo.categoryQualificateImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="电子签章" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('sealImage', {
                    rules: [{ required: true, message: '请上传电子签章!' }],
                    initialValue: businessInfo.sealImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, {
                        keyName: 'sealImage',
                        type: 3,
                        maxSize: 1024 * 200,
                        maxSizeMsg: '文件大小不能超过200K',
                        limit: 1,
                      })}
                      fileList={businessInfo.sealImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
            </Row>
          </Card>
          <Card title="法人信息录入区">
            <Row gutter={24}>
              <Col span={12} className={styles.imgList}>
                <FormItem label="法人身份证人像面" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('idCardPortraitImage', {
                    rules: [{ required: true, message: '请上传身份证人像面!' }],
                    initialValue: businessInfo.idCardPortraitImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'idCardPortraitImage', type: 5 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.idCardPortraitImage}
                    >
                      <UploadOutlined />
                      <div>身份证人像面</div>
                    </Upload>,
                  )}
                </FormItem>
              </Col>
              <Col span={12} className={styles.imgList}>
                <FormItem label="法人身份证国徽面" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('idCardEmblemImage', {
                    rules: [{ required: true, message: '请上传身份证国徽面!' }],
                    initialValue: businessInfo.idCardEmblemImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'idCardEmblemImage', type: 4 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.idCardEmblemImage}
                    >
                      <UploadOutlined />
                      <div>身份证国徽面</div>
                    </Upload>,
                  )}
                </FormItem>
              </Col>

              <Col span={12}>
                <FormItem label="证件姓名" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonName', {
                    rules: [{ required: true, message: '请输入证件姓名!' }],
                    initialValue: businessInfo.legalPersonName,
                  })(<Input maxLength={8} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="身份证号码" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonIdCard', {
                    rules: [{ required: true, message: '请输入身份证号码!' }],
                    initialValue: businessInfo.legalPersonIdCard,
                  })(<Input maxLength={18} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="身份证有效期" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonPeriod', {
                    rules: [{ required: true, message: '请输入身份证有效期!' }],
                    initialValue: businessInfo.legalPersonPeriod,
                  })(<RangePicker />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label="手机号" labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonPhone', {
                    rules: [
                      { required: true, message: '请输入手机号!' },
                      { validator: validatePhone, message: '请输入正确的手机号!' },
                    ],
                    initialValue: businessInfo.legalPersonPhone,
                  })(<Input maxLength={11} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="其它证照" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('otherImage', {
                    initialValue: businessInfo.otherImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(this, { keyName: 'otherImage', limit: 9, type: 7 })}
                      fileList={businessInfo.otherImage}
                    >
                      <UploadOutlined /> 上传文件
                    </Upload>,
                  )}
                </FormItem>
              </Col>
            </Row>
          </Card>
          <Card title="结算信息录入区">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="账户类型" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('settlementType', {
                    rules: [{ required: true, message: '请选择账户类型!' }],
                    initialValue: businessInfo.settlementType,
                  })(
                    <Radio.Group onChange={e => this.onChangeSettlType(e)}>
                      <Radio value={1}>对公</Radio>
                      <Radio value={2}>对私(小微商户)</Radio>
                    </Radio.Group>,
                  )}
                </FormItem>
              </Col>
            </Row>
            {this.state.settlementType === 1 && (
              <Row gutter={24}>
                <Col span={12}>
                  <FormItem label="开户许可证" labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('accountOpenPermitImage', {
                      rules: [{ required: true, message: '请上传开户许可证!' }],
                      initialValue: businessInfo.accountOpenPermitImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'accountOpenPermitImage',
                          type: 8,
                        })}
                        fileList={businessInfo.accountOpenPermitImage}
                      >
                        <UploadOutlined /> 上传文件
                      </Upload>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户许可证编号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountLicenseNum', {
                      rules: [{ required: true, message: '请输入开户许可证编号!' }],
                      initialValue: businessInfo.bankAccountLicenseNum,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户名称" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountName', {
                      rules: [{ required: true, message: '请输入开户名称!' }],
                      initialValue: businessInfo.bankAccountName,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户行" labelCol={{ span: 8 }}>
                    {getFieldDecorator('accountBankName', {
                      rules: [{ required: true, message: '请选择开户行!' }],
                      initialValue: businessInfo.accountBankName,
                    })(
                      <Select
                        showSearch
                        filterOption={(input, option) =>
                          (option?.value ?? '').toLowerCase().includes(input.toLowerCase())
                        }
                      >
                        {this.state.bankList.map(item => (
                          <Option value={item.bankName} key={item.bankName}>
                            {item.bankName}
                          </Option>
                        ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="银行帐号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccount', {
                      rules: [{ required: true, message: '请输入银行帐号!' }],
                      initialValue: businessInfo.bankAccount,
                    })(<Input maxLength={20} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="联行号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('interbankNum', {
                      initialValue: businessInfo.interbankNum,
                    })(<Input maxLength={50} />)}
                  </FormItem>
                </Col>
              </Row>
            )}
            {this.state.settlementType === 2 && (
              <Row gutter={24}>
                <Col span={12}>
                  <FormItem label="银行卡类型" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountType', {
                      rules: [{ required: true, message: '请选择银行卡类型!' }],
                      initialValue: businessInfo.bankAccountType,
                    })(
                      <Select>
                        <Option value={1} key={1}>
                          借记卡
                        </Option>
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户名称" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountName', {
                      rules: [{ required: true, message: '请输入开户名称!' }],
                      initialValue: businessInfo.bankAccountName,
                    })(<Input maxLength={32} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="开户行" labelCol={{ span: 8 }}>
                    {getFieldDecorator('accountBankName', {
                      rules: [{ required: true, message: '请选择开户行!' }],
                      initialValue: businessInfo.accountBankName,
                    })(
                      <Select
                        showSearch
                        filterOption={(input, option) =>
                          (option?.value ?? '').toLowerCase().includes(input.toLowerCase())
                        }
                      >
                        {this.state.bankList.map(item => (
                          <Option value={item.bankName} key={item.bankName}>
                            {item.bankName}
                          </Option>
                        ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label="银行帐号" labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccount', {
                      rules: [{ required: true, message: '请输入银行帐号!' }],
                      initialValue: businessInfo.bankAccount,
                    })(<Input maxLength={20} />)}
                  </FormItem>
                </Col>
              </Row>
            )}
          </Card>
          <Card title="其他信息">
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label="礼包内容" labelCol={{ span: 4 }}>
                  {getFieldDecorator('giftPackageContent', {
                    // rules: [{ required: true, message: '请输入礼包内容!' }],
                    initialValue: businessInfo.giftPackageContent,
                  })(<Input style={{ width: '50%' }} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label="邀请码" labelCol={{ span: 4 }}>
                  {getFieldDecorator('invitationCode', {
                    // rules: [{ required: true, message: '请输入礼包内容!' }],
                    initialValue: businessInfo.invitationCode,
                  })(<Input style={{ width: '50%' }} />)}
                </FormItem>
              </Col>
            </Row>
          </Card>
          {this.state.type === infoTypeChecked && [
            <Card title="信息审核区" key="checked">
              <Row gutter={24}>
                {businessInfo.applyType && (
                  <Col span={24}>
                    <FormItem label="上级节点" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                      {applyTypeDesc[businessInfo.applyType] || ''}
                      {businessInfo.remark}
                    </FormItem>
                  </Col>
                )}
                <Col span={24}>
                  <FormItem label="审核结果" labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('auditResult', {
                      rules: [{ required: true, message: '请选择审核结果!' }],
                      initialValue: businessInfo.auditResult,
                    })(
                      <Radio.Group onChange={this.onChangeAuditResult}>
                        <Radio value>通过</Radio>
                        <Radio value={false}>驳回</Radio>
                      </Radio.Group>,
                    )}
                  </FormItem>
                </Col>
                <Col span={24}>
                  <FormItem label="审核结果" labelCol={{ span: 4 }}>
                    {getFieldDecorator('auditRemark', {
                      rules: [{ required: true, message: '请输入审核结果!' }],
                      initialValue: businessInfo.auditRemark,
                    })(<Input maxLength={500} />)}
                  </FormItem>
                </Col>
              </Row>
            </Card>,
            this.state.visibleCalculate && (
              <Card title="商户服务费率配置" key="set">
                <Tabs defaultActiveKey={this.state.defaultType} onChange={this.onTabChange}>
                  {businessInfo.businessType.map((item, i) => (
                    <TabPane tab={item.name} key={item.key}>
                      <Row gutter={24}>
                        <Col span={12}>
                          <Form.Item label="商户编码">
                            <span>{businessInfo.id}</span>
                          </Form.Item>
                          <Form.Item label="商户类型" hidden>
                            {getFieldDecorator(`supplierRateDTOList[${i}]['businessType']`, {
                              initialValue: item.key,
                            })(<Input />)}
                          </Form.Item>
                          {/* <Form.Item label="供应商ID" hidden>
                            {getFieldDecorator(`supplierRateDTOList[${i}]['supplierId']`, {
                              initialValue: businessInfo.businessType[i].supplierId,
                            })(<Input />)}
                          </Form.Item>
                          <Form.Item label="费率ID" hidden>
                            {getFieldDecorator(`supplierRateDTOList[${i}]['id']`, {
                              initialValue: businessInfo.businessType[i].id,
                            })(<Input />)}
                          </Form.Item> */}
                        </Col>
                        <Col span={12}>
                          <Form.Item label="商户名称">
                            <span>{businessInfo.name}</span>
                          </Form.Item>
                        </Col>
                        <Col span={12}>
                          <Form.Item label="计费类型">
                            {getFieldDecorator(`supplierRateDTOList[${i}]['calculateType']`, {
                              initialValue: businessInfo.businessType[i].calculateType,
                              rules: [{ required: true, message: '请选择计费类型!' }],
                            })(
                              <Select
                                placeholder="请选择"
                                disabled={!!item.id}
                                onChange={e => this.onChangeCalculateType(e, i)}
                              >
                                <Option value={1}>单笔百分比</Option>
                                {/* <Option value={2}>单笔固定值</Option> */}
                              </Select>,
                            )}
                          </Form.Item>
                        </Col>
                        <Col span={12}>
                          <Form.Item label={this.state.calculateType[i] === 1 ? '百分比' : ''}>
                            {getFieldDecorator(`supplierRateDTOList[${i}]['calculateValue']`, {
                              initialValue: businessInfo.businessType[i].calculateValue,
                              rules: [
                                { required: true, message: '请输入百分比!' },
                                // { min: 0, message: '最小0' },
                                // { max: 0.9999, message: '最大输入0.9999' },
                                { validator: validNumber, message: '请输入0～0.9999之间的小数' },
                              ],
                            })(
                              <Input
                                maxLength={6}
                                placeholder={
                                  this.state.calculateType[i] === 1
                                    ? '0.1=10%，直接写小数形式即可'
                                    : ''
                                }
                              />,
                            )}
                          </Form.Item>
                        </Col>
                        <Col span={12}>
                          <Form.Item label="收取方式">
                            {getFieldDecorator(`supplierRateDTOList[${i}]['chargeMethod']`, {
                              initialValue: businessInfo.businessType[i].chargeMethod,
                              rules: [{ required: true, message: '请选择收取方式!' }],
                            })(
                              <Select placeholder="请选择" disabled={!!item.id}>
                                <Option value={1}>坐扣</Option>
                              </Select>,
                            )}
                          </Form.Item>
                        </Col>
                        <Col span={12}>
                          <Form.Item label="有效期">
                            {getFieldDecorator(`supplierRateDTOList[${i}]['ratedate']`, {
                              initialValue: businessInfo.businessType[i].ratedate,
                              rules: [{ required: true, message: '请选择有效期!' }],
                            })(
                              <RangePicker format="YYYY/MM/DD" disabledDate={this.disabledDate} />,
                            )}
                          </Form.Item>
                        </Col>
                      </Row>
                    </TabPane>
                  ))}
                </Tabs>
              </Card>
            ),
          ]}
          <div className={styles.formBtns}>
            <Row gutter={24}>
              <Col span={4}></Col>
              <Col span={20}>
                {!this.state.id || [infoTypeEdit, infoTypeChecked].includes(this.state.type) ? (
                  <Button
                    type="primary"
                    size="large"
                    htmlType="submit"
                    loading={this.state.loading}
                  >
                    保存
                  </Button>
                ) : (
                  ''
                )}
                {type === infoTypeRevision && (
                  <Button
                    type="primary"
                    size="large"
                    onClick={this.onRevision}
                    loading={this.state.loading}
                  >
                    保存
                  </Button>
                )}
                <Button size="large" onClick={this.onCancel}>
                  取消
                </Button>
              </Col>
            </Row>
          </div>
        </Form>
        <MapModal
          visible={this.state.visibleMap}
          onCancel={() => this.openMap(false)}
          onSetPoint={e => this.onSetPoint(e)}
        ></MapModal>
        {this.state.visibleLoading && (
          <div className={styles.spinBox}>
            <div className={styles.spinBoxWrapper}>
              <Spin tip="Loading..." />
            </div>
          </div>
        )}
      </div>
    );
  }
}
export default Form.create()(BusinessInfo);
