import { Button, Popconfirm } from 'antd';
import React from 'react';
// import router from 'umi/router';
import { history } from 'umi';

// 状态：0-填写未完成，1-待审核，2-待易宝入网，3-易宝入网中，4-待易宝签约，5-待平台签约，6-完成，7-驳回
export const checkStatus = {
  // 0: { text: '填写未完成' },
  1: { text: '待审核' },
  // 2: { text: '待易宝入网' },
  3: { text: '易宝入网中' },
  4: { text: '待易宝签约' },
  5: { text: '待平台签约' },
  // 6: { text: '完成' },
  // 7: { text: '驳回' },
};

// 详情类型
export const infoTypeFind = 'find'; // 查看
export const infoTypeChecked = 'checked'; // 审核
export const infoTypeEdit = 'edit'; // 编辑
export const infoTypeRevision = 'revision'; // 订正
export const infoTypeInfo = 'info'; // 审核之后查看
export const infoTypeAdd = 'add'; // 添加

// 商户类型
export const supplierType = {
  pop: { text: 'POP商户' },
  供应商: { text: '供应商' },
};

export const toInfo = ({ id }, type = 'find') => {
  history.push(`/BusinessInfo?id=${id}&type=${type}`);
};

export const businessTypeDesc = {
  1: '到家业务',
  2: '实物业务',
  3: '到店业务',
};
