import React, { forwardRef, useState } from 'react';
import { Modal, Radio, Form, TimePicker, Checkbox } from 'antd';
import { MinusSquareOutlined, PlusSquareOutlined } from '@ant-design/icons';
import { saleWeeks } from '../../staticdata';
import styles from '../../style.less';

const WeekTime = forwardRef(options => {
  const [form] = Form.useForm();
  const [type, setType] = useState(1);

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 6 },
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 16 },
    },
  };
  const formItemLayoutWithOutLabel = {
    wrapperCol: {
      xs: { span: 22, offset: 0 },
      sm: { span: 16, offset: 6 },
    },
  };

  const onChangeType = ({ target: { value } }) => {
    setType(value);
  };

  const radioOptions = [{ label: '全时段', value: 1 }, { label: '自定义售卖时间', value: 2 }];

  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    console.log('111 :>> ', 111);
    const values = await form.validateFields();
    console.log('values :>> ', values);
  };

  const initialValues = Object.assign(
    {
      saleTimeType: 1,
      saleDates: [],
      saleTimes: [[]],
    },
    options.initialValues,
  );

  return (
    <Modal
      visible={options.visible}
      title="售卖时间"
      onOk={handleOk}
      maskClosable={false}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label="售卖时间段类型"
          name="saleTimeType"
          rules={[{ required: true, message: '请选择售卖时间段类型!' }]}
        >
          <Radio.Group
            options={radioOptions}
            onChange={onChangeType}
            value={type}
            optionType="button"
            buttonStyle="solid"
          />
        </Form.Item>
        {type === 2 ? (
          <>
            <Form.Item
              label="售卖日期"
              name="saleDates"
              rules={[{ required: true, message: '请选择售卖日期!' }]}
            >
              <Checkbox.Group options={saleWeeks} />
            </Form.Item>
            <Form.List
              label="售卖时间"
              name="saleTimes"
              rules={[
                {
                  validator: async (_, saleTimes) => {
                    if (!saleTimes || saleTimes.length < 1) {
                      return Promise.reject(new Error('请选择售卖时间!'));
                    }
                    return Promise.resolve();
                  },
                },
              ]}
            >
              {(fields, { add, remove }) => (
                <>
                  {fields.map((field, index) => (
                    <Form.Item
                      label={index === 0 ? '售卖日期' : ''}
                      {...(index === 0 ? formItemLayout : formItemLayoutWithOutLabel)}
                      required
                      key={field.key}
                    >
                      <Form.Item
                        {...field}
                        validateTrigger={['onChange', 'onBlur']}
                        rules={[
                          {
                            required: true,
                            message: '请选择售卖时间',
                          },
                        ]}
                        noStyle
                      >
                        <TimePicker.RangePicker format="HH:mm" minuteStep={30} />
                      </Form.Item>
                      {index > 0 ? (
                        <MinusSquareOutlined
                          className={[styles['week-time-box--icon'], styles.error]}
                          onClick={() => remove(field.name)}
                        />
                      ) : (
                        <PlusSquareOutlined
                          className={[styles['week-time-box--icon'], styles.primary]}
                          onClick={() => add()}
                        />
                      )}
                    </Form.Item>
                  ))}
                </>
              )}
            </Form.List>
          </>
        ) : (
          ''
        )}
      </Form>
    </Modal>
  );
});

export default WeekTime;
