import React from 'react';
import { Button, Dropdown, Menu, message, Modal } from 'antd';
import { PlusOutlined, DownOutlined, ExclamationCircleOutlined } from '@ant-design/icons';
import { batchAction } from '../../staticdata';
import styles from '../../style.less';
import { apiChangeStateGoods } from './service';

const ActionBar = options => {
  // 上下架
  const changeStatus = async state => {
    Modal.confirm({
      icon: <ExclamationCircleOutlined />,
      content: `确认${+state === 6 ? '下架' : '上架'}商品？`,
      onOk: async () => {
        const res = await apiChangeStateGoods({
          ids: options.selectedRowKeys,
          productState: +state === 6 ? 7 : 6, // 6：上架，7:下架
        });
        if (res.businessCode === '0000' && res.code === '0000') {
          options.handleSearch();
        }
      },
    });
  };

  /**
   * 批量操作
   * up     上架
   * down   下架
   * stock  修改库存
   * time   修改可售时间
   * group  修改分组
   * send   设置单点不送
   * buy    修改最少购买数量
   */
  const onChangeState = type => {
    if (options.selectedRowKeys && options.selectedRowKeys.length) {
      switch (type) {
        case 'up':
          changeStatus(7);
          break;
        case 'down':
          changeStatus(6);
          break;
        case 'stock':
          options.openModal('stock');
          break;
        case 'time':
          options.openModal('time');
          break;
        case 'buy':
          changeStatus(7);
          break;
        default:
          changeStatus(7);
          break;
      }
    } else {
      message.warning('请选择商品！');
    }
  };

  const eventObj = {
    onChangeState,
  };
  const actions = batchAction(eventObj);

  const menus = (
    <Menu>
      {actions.map(item => (
        <Menu.Item key={item.key}>{item.label}</Menu.Item>
      ))}
    </Menu>
  );

  return (
    <div className={styles['action-bar-box']}>
      <Button type="primary" icon={<PlusOutlined />}>
        该分组下新增商品
      </Button>
      <Dropdown overlay={menus} className={styles['action-bar-box--down']} placement="bottomLeft">
        <Button type="primary">
          批量操作 <DownOutlined />
        </Button>
      </Dropdown>
    </div>
  );
};

export default ActionBar;
