import React, { forwardRef, useImperativeHandle, useState, useRef, useEffect } from 'react';
import { Modal, Select, notification, Form, Input, Button, Checkbox } from 'antd';
import { PlusCircleOutlined, MinusCircleOutlined } from '@ant-design/icons';
import { userEnabled, userDisabled, userDelete } from '@/pages/systemManage/service';
import styles from './index.less';

const FormComponent = (props, ref) => {
  const { record = {}, companys = [] } = props;
  const { mchOrderSkuVoList, packageList } = record;
  const [form] = Form.useForm();
  const [addPackageList, setAddPackageList] = useState({
    expressCompanyCode: null,
    expressCompanyName: '',
    expressNo: '',
    serialNumber: '',
    skuInfoList: mchOrderSkuVoList.map(item => ({})),
  });

  const [initPackageList, setInitPackageList] = useState(() => {
    if (packageList.length === 0) {
      return [
        {
          skuInfoList: mchOrderSkuVoList.map(item => ({ skuNo: [item.skuNo], quantity: 1 })),
        },
      ];
    }
    return packageList.map(item => ({
      ...item,
      skuInfoList: mchOrderSkuVoList.map((skuInfo, index) => {
        console.log(item.skuInfoList);
        const editData = item.skuInfoList[index];
        if (editData) {
          return {
            ...editData,
          };
        }
        return {};
      }),
    }));
  });

  // eslint-disable-next-line consistent-return
  const onCheckSkuInfoList = async (_, names) => {
    const count = names.filter(item => {
      console.log('sku', item.skuNo);
      return item.skuNo && item.skuNo.length;
    }).length;
    if (count === 0) {
      return Promise.reject(new Error('至少选择一个商品'));
    }
  };

  const formLayout = {
    labelCol: { span: 0 },
    wrapperCol: { span: 24 },
  };
  const formRules = {
    skuInfoList: [{ validator: onCheckSkuInfoList }],
    expressCompanyCode: [{ required: true, message: '请选择物流公司' }],
    expressNo: [{ required: true, message: '请填写物流单号' }],
    serialNumber: [{ required: true, message: '请填写序列号' }],
  };

  useEffect(() => {
    console.log(initPackageList);
    console.log(companys, mchOrderSkuVoList);
  }, [record]);

  useImperativeHandle(ref, () => ({
    form,
  }));

  const getSkuOptions = (index, parentIndex) => {
    const { skuNo, skuName } = mchOrderSkuVoList[index];
    return (
      <Checkbox.Group>
        <Checkbox value={skuNo}>{skuName}</Checkbox>
      </Checkbox.Group>
    );
  };

  const SkuFormList = skuProps => {
    const { skuFields, parentFields, errors } = skuProps;
    return (
      <div className={styles['sku-list-box']}>
        {skuFields.map(field => (
          <div className={styles['sku-list']}>
            <Form.Item className={styles['sku-list__goods-name']} name={[field.name, 'skuNo']}>
              {getSkuOptions(field.name, parentFields.name)}
            </Form.Item>
            <Form.Item className={styles['sku-list__goods-count']} name={[field.name, 'quantity']}>
              <Input type="number" placeholder="数量" />
            </Form.Item>
          </div>
        ))}
        <Form.ErrorList errors={errors} />
      </div>
    );
  };

  return (
    <Form
      form={form}
      {...formLayout}
      initialValues={{
        packageList: initPackageList,
      }}
    >
      <Form.List name="packageList" rules={[]}>
        {(fields, { add, remove }, { errors }) => (
          <>
            {fields.map((field, index) => (
              <div className={styles['sku-list-module']}>
                <Form.List name={[field.name, 'skuInfoList']} rules={formRules.skuInfoList}>
                  {(skuFields, actions, { errors: err }) => (
                    <SkuFormList
                      key={index.toString()}
                      skuFields={skuFields}
                      parentFields={field}
                      errors={err}
                    />
                  )}
                </Form.List>
                <Form.Item
                  name={[field.name, 'expressCompanyCode']}
                  rules={formRules.expressCompanyCode}
                >
                  <Select
                    placeholder="请选择物流公司"
                    fieldNames={{ label: 'expressCompanyName', value: 'expressCompanyCode' }}
                    options={companys}
                  ></Select>
                </Form.Item>
                <Form.Item name={[field.name, 'expressNo']} rules={formRules.expressNo}>
                  <Input placeholder="请填写物流单号" />
                </Form.Item>
                <Form.Item name={[field.name, 'serialNumber']} rules={formRules.serialNumber}>
                  <Input placeholder="请填写序列号" />
                </Form.Item>
              </div>
            ))}

            <div className={styles.operation}>
              <PlusCircleOutlined
                onClick={() => {
                  const currentPackageList = form.getFieldValue('packageList');
                  console.log(currentPackageList);
                  form.setFieldsValue({
                    packageList: [...currentPackageList, addPackageList],
                  });
                }}
              />
              <MinusCircleOutlined
                onClick={() => {
                  remove(fields[fields.length - 1].name);
                }}
              />
            </div>
          </>
        )}
      </Form.List>
    </Form>
  );
};
const FormWarpper = forwardRef(FormComponent);

const UpdateStatusModal = (props, ref) => {
  const { companys } = props;
  const formRef = useRef();
  const [visible, setVisible] = useState(false);
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [record, setRecord] = useState();

  // 提交前处理数据结构将skuNo的值从[skuNo]=>skuNo
  const onFilterParams = packageList => {
    const currentPackageList = JSON.parse(JSON.stringify(packageList));
    return currentPackageList.map(item => {
      const { skuInfoList } = item;
      return {
        ...item,
        skuInfoList: skuInfoList
          .filter(skuInfo => skuInfo.skuNo.length)
          .map(skuInfo => ({ ...skuInfo, skuNo: skuInfo.skuNo[0] })),
      };
    });
  };

  const open = item => {
    setVisible(true);
    setRecord(item);
  };

  const onCancel = () => {
    setVisible(false);
    setConfirmLoading(false);
    formRef.current.form.resetFields();
  };

  const onOk = () => {
    formRef.current.form.validateFields().then(values => {
      console.log('fieldsValue :>>', onFilterParams(values.packageList));
    });
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: '填写物流信息',
    height: 500,
    visible,
    confirmLoading,
    onCancel,
    onOk,
  };

  return (
    <Modal {...modalProps}>
      {record ? <FormWarpper ref={formRef} record={record} companys={companys} /> : ''}
    </Modal>
  );
};

export default forwardRef(UpdateStatusModal);
