import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { kdspApi } = config;

// 分页查询所有数据
export async function searchList(params) {
  const param = {
    ...params,
    pageNo: params.current,
    pageSize: params.pageSize || 20,
  };
  const data = await request.post('/shop/pageQuery', {
    prefix: kdspApi,
    data: _.omitBy(param, v => !v),
    // headers: {
    //   'Content-Type': 'application/x-www-form-urlencoded',
    // },
  });
  if (data.data) {
    return {
      total: data.data.total,
      data: data.data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

// 停启用门店
export async function apiEnableStore({ id, state }) {
  const data = await request.get(`/shop/updateState/${id}/${state}`, {
    prefix: kdspApi,
  });
  return data.businessCode;
}

// 获取地址
export async function apiAddrArea(params) {
  const data = await request.post('/api/kdsp/area/addr/query', {
    prefix: kdspApi,
    data: _.omitBy(params, v => !v),
  });
  return data.businessCode;
}
